/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.UnpackedJarEntry;

public class UnpackedJarFile
extends JarFile {
    private final File baseDir;
    private boolean manifestLoaded = false;
    private Manifest manifest;

    public UnpackedJarFile(File baseDir) throws IOException {
        super(JarUtils.DUMMY_JAR_FILE);
        this.baseDir = baseDir;
        if (!baseDir.isDirectory()) {
            throw new IOException("File must be a directory: file=" + baseDir.getAbsolutePath());
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            File manifestFile = this.getFile("META-INF/MANIFEST.MF");
            if (manifestFile != null && manifestFile.isFile()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(manifestFile);
                    this.manifest = new Manifest(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    public UnpackedJarEntry getUnpackedJarEntry(String name) {
        File file = this.getFile(name);
        if (file == null) {
            return null;
        }
        return new UnpackedJarEntry(name, file, this.getManifestSafe());
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return this.getUnpackedJarEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.getUnpackedJarEntry(name);
    }

    public Enumeration entries() {
        Collection<File> files = FileUtils.listRecursiveFiles(this.baseDir);
        Manifest manifest = this.getManifestSafe();
        LinkedList<UnpackedJarEntry> entries = new LinkedList<UnpackedJarEntry>();
        URI baseURI = this.baseDir.getAbsoluteFile().toURI();
        Iterator<File> iterator = files.iterator();
        while (iterator.hasNext()) {
            File entryFile = iterator.next().getAbsoluteFile();
            URI entryURI = entryFile.toURI();
            URI relativeURI = baseURI.relativize(entryURI);
            entries.add(new UnpackedJarEntry(relativeURI.getPath(), entryFile, manifest));
        }
        return Collections.enumeration(entries);
    }

    @Override
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        File file = zipEntry instanceof UnpackedJarEntry ? ((UnpackedJarEntry)zipEntry).getFile() : this.getFile(zipEntry.getName());
        if (file == null) {
            throw new IOException("Entry not found: name=" + zipEntry.getName());
        }
        if (file.isDirectory()) {
            return new IOUtils.EmptyInputStream();
        }
        return new FileInputStream(file);
    }

    @Override
    public String getName() {
        return this.baseDir.getAbsolutePath();
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws IOException {
    }

    public File getFile(String name) {
        File file = new File(this.baseDir, name);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private Manifest getManifestSafe() {
        Manifest manifest = null;
        try {
            manifest = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifest;
    }
}

