/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ClassLoadingRule
implements Serializable {
    private final Set<String> classPrefixes = new HashSet<String>();
    private final Set<String> resourcePrefixes = new HashSet<String>();

    public Set<String> getClassPrefixes() {
        return this.classPrefixes;
    }

    public boolean isFilteredClass(String name) {
        return this.isMatching(this.classPrefixes, name);
    }

    public boolean isFilteredResource(String name) {
        return this.isMatching(this.resourcePrefixes, name);
    }

    public void addClassPrefixes(Set<String> classPrefixes) {
        this.classPrefixes.addAll(classPrefixes);
        Set<String> resources = this.toResources(classPrefixes);
        this.resourcePrefixes.addAll(resources);
    }

    public void setClassPrefixes(Set<String> classPrefixes) {
        this.classPrefixes.clear();
        this.resourcePrefixes.clear();
        this.addClassPrefixes(classPrefixes);
    }

    public void merge(ClassLoadingRule classLoadingRuleToMerge) {
        this.addClassPrefixes(classLoadingRuleToMerge.classPrefixes);
    }

    protected Set<String> toResources(Set<String> classPrefixes) {
        HashSet<String> resources = new HashSet<String>();
        for (String className : classPrefixes) {
            resources.add(className.replace('.', '/'));
        }
        return resources;
    }

    protected boolean isMatching(Set<String> prefixes, String name) {
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

