/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicKernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationMarshaler;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.DependencyNode;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.SerializedConfigurationMarshaler;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Maven2Repository;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUtil.class);
    private static final ConfigurationMarshaler configurationMarshaler;
    private static File bootDirectory;

    private static File getStartupDirectory() {
        URL url = ConfigurationUtil.class.getClassLoader().getResource("META-INF/startup-jar");
        File directory = null;
        if (url != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                URI baseURI = new URI(url.toString()).resolve("..");
                directory = new File(baseURI);
            }
            catch (Exception ignored) {
                log.error("Error while determining the installation directory of Apache Geronimo", (Throwable)ignored);
            }
        } else {
            log.error("Cound not determine the installation directory of Apache Geronimo, because the startup jar could not be found in the current class loader.");
        }
        return directory;
    }

    private static File getBootDirectory() {
        if (bootDirectory == null) {
            bootDirectory = ConfigurationUtil.getStartupDirectory();
        }
        return bootDirectory;
    }

    public static ConfigurationMarshaler createConfigurationMarshaler(String marshalerClass) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class clazz = null;
        if (classLoader != null) {
            try {
                clazz = ClassLoading.loadClass(marshalerClass, classLoader);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = ConfigurationUtil.class.getClassLoader();
            try {
                clazz = ClassLoading.loadClass(marshalerClass, classLoader);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (clazz != null) {
            Object object = clazz.newInstance();
            if (object instanceof ConfigurationMarshaler) {
                return (ConfigurationMarshaler)object;
            }
            log.warn("Configuration marshaler class is not an instance of ConfigurationMarshaler " + marshalerClass + ": using default configuration ");
        }
        return null;
    }

    private ConfigurationUtil() {
    }

    public static GBeanState newGBeanState(Collection gbeans) {
        return configurationMarshaler.newGBeanState(gbeans);
    }

    public static AbstractName loadBootstrapConfiguration(Kernel kernel, InputStream in, BundleContext bundleContext) throws Exception {
        return ConfigurationUtil.loadBootstrapConfiguration(kernel, in, bundleContext, false);
    }

    public static AbstractName loadBootstrapConfiguration(Kernel kernel, InputStream in, BundleContext bundleContext, boolean enableBootRepo) throws Exception {
        ConfigurationData configurationData = ConfigurationUtil.readConfigurationData(in);
        return ConfigurationUtil.loadBootstrapConfiguration(kernel, configurationData, bundleContext, enableBootRepo);
    }

    public static AbstractName loadBootstrapConfiguration(Kernel kernel, ConfigurationData configurationData, BundleContext bundleContext) throws Exception {
        return ConfigurationUtil.loadBootstrapConfiguration(kernel, configurationData, bundleContext, false);
    }

    public static AbstractName loadBootstrapConfiguration(Kernel kernel, ConfigurationData configurationData, BundleContext bundleContext, boolean enableBootRepo) throws Exception {
        if (kernel == null) {
            throw new NullPointerException("kernel is null");
        }
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        if (bundleContext == null) {
            throw new NullPointerException("bundle is null");
        }
        configurationData.setBundleContext(bundleContext);
        Artifact configId = configurationData.getId();
        AbstractName abstractName = Configuration.getConfigurationAbstractName(configId);
        GBeanData gbeanData = new GBeanData(abstractName, Configuration.class);
        gbeanData.setAttribute("configurationData", configurationData);
        Set<Maven2Repository> repositories = null;
        DefaultArtifactResolver artifactResolver = null;
        if (enableBootRepo) {
            String repository = System.getProperty("Xorg.apache.geronimo.repository.boot.path", "repository");
            Maven2Repository bootRepository = new Maven2Repository(new File(ConfigurationUtil.getBootDirectory(), repository));
            repositories = Collections.singleton(bootRepository);
            artifactResolver = new DefaultArtifactResolver(new DefaultArtifactManager(), bootRepository);
        } else {
            List<Dependency> dependencies = configurationData.getEnvironment().getDependencies();
            if (!dependencies.isEmpty()) {
                configurationData.getEnvironment().setDependencies(Collections.EMPTY_SET);
            }
        }
        ConfigurationResolver configurationResolver = new ConfigurationResolver(configurationData, repositories, artifactResolver);
        DependencyNode dependencyNode = new DependencyNode(configId, new LinkedHashSet<Artifact>(), new LinkedHashSet<Artifact>());
        gbeanData.setAttribute("dependencyNode", dependencyNode);
        gbeanData.setAttribute("allServiceParents", Collections.emptyList());
        kernel.loadGBean(gbeanData, bundleContext);
        kernel.startGBean(gbeanData.getAbstractName());
        Configuration configuration = (Configuration)kernel.getGBean(gbeanData.getAbstractName());
        ConfigurationUtil.startConfigurationGBeans(configuration.getAbstractName(), configuration, kernel);
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager(kernel);
        configurationManager.loadConfiguration(configId);
        return gbeanData.getAbstractName();
    }

    public static void writeConfigurationData(ConfigurationData configurationData, OutputStream out) throws IOException {
        configurationMarshaler.writeConfigurationData(configurationData, out);
    }

    public static ConfigurationData readConfigurationData(InputStream in) throws IOException, ClassNotFoundException {
        return configurationMarshaler.readConfigurationData(in);
    }

    public static void writeConfigInfo(PrintWriter writer, ConfigurationData configurationData) {
        ConfigurationUtil.writeConfigInfo("", writer, configurationData);
    }

    private static void writeConfigInfo(String prefix, PrintWriter writer, ConfigurationData configurationData) {
        writer.println(prefix + "id=" + configurationData.getId());
        writer.println(prefix + "type=" + configurationData.getModuleType());
        writer.println(prefix + "created=" + configurationData.getCreated());
        Set<Artifact> ownedConfigurations = configurationData.getOwnedConfigurations();
        int i = 0;
        for (Artifact ownedConfiguration : ownedConfigurations) {
            writer.println(prefix + "owned." + i++ + "=" + ownedConfiguration);
        }
        i = 0;
        for (ConfigurationData data : configurationData.getChildConfigurations().values()) {
            ConfigurationUtil.writeConfigInfo("child." + i++ + ".", writer, data);
        }
        writer.flush();
    }

    public static ConfigurationInfo readConfigurationInfo(InputStream in, AbstractName storeName, File inPlaceLocation) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        return ConfigurationUtil.readConfigurationInfo("", properties, storeName, inPlaceLocation);
    }

    private static ConfigurationInfo readConfigurationInfo(String prefix, Properties properties, AbstractName storeName, File inPlaceLocation) throws IOException {
        String next;
        String value;
        long time;
        String id = properties.getProperty(prefix + "id");
        Artifact configId = Artifact.create(id);
        String type = properties.getProperty(prefix + "type");
        ConfigurationModuleType moduleType = ConfigurationModuleType.getByName(type);
        if (moduleType == null) {
            throw new IllegalArgumentException("Unknown module type: " + type);
        }
        String created = properties.getProperty(prefix + "created");
        try {
            time = Long.parseLong(created);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid created time: " + created);
        }
        LinkedHashSet<Artifact> ownedConfigurations = new LinkedHashSet<Artifact>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(prefix + "owned.")) continue;
            value = (String)entry.getValue();
            Artifact ownedConfiguration = Artifact.create(value);
            ownedConfigurations.add(ownedConfiguration);
        }
        LinkedHashSet<ConfigurationInfo> childConfigurations = new LinkedHashSet<ConfigurationInfo>();
        int test = 0;
        while ((value = properties.getProperty((next = prefix + "child." + test + ".") + ".id")) != null) {
            childConfigurations.add(ConfigurationUtil.readConfigurationInfo(next, properties, storeName, inPlaceLocation));
            ++test;
        }
        return new ConfigurationInfo(storeName, configId, moduleType, time, ownedConfigurations, childConfigurations, inPlaceLocation);
    }

    public static AbstractName getConfigurationManagerName(Kernel kernel) {
        Set<AbstractName> names = kernel.listGBeans(new AbstractNameQuery(ConfigurationManager.class.getName()));
        Iterator<AbstractName> iterator = names.iterator();
        while (iterator.hasNext()) {
            AbstractName abstractName = iterator.next();
            if (kernel.isRunning(abstractName)) continue;
            iterator.remove();
        }
        if (names.isEmpty()) {
            throw new IllegalStateException("A Configuration Manager could not be found in the kernel");
        }
        if (names.size() > 1) {
            String error = "More than one Configuration Manager was found in the kernel: ";
            Iterator<AbstractName> i$ = names.iterator();
            while (i$.hasNext()) {
                AbstractName name;
                AbstractName abName = name = i$.next();
                error = error + "\"" + abName.toString() + "\" ";
            }
            throw new IllegalStateException(error);
        }
        return names.iterator().next();
    }

    public static ConfigurationManager getConfigurationManager(Kernel kernel) throws GBeanNotFoundException {
        return kernel.getGBean(ConfigurationManager.class);
    }

    public static EditableConfigurationManager getEditableConfigurationManager(Kernel kernel) {
        Set<AbstractName> names = kernel.listGBeans(new AbstractNameQuery(EditableConfigurationManager.class.getName()));
        Iterator<AbstractName> iterator = names.iterator();
        while (iterator.hasNext()) {
            AbstractName abstractName = iterator.next();
            if (kernel.isRunning(abstractName)) continue;
            iterator.remove();
        }
        if (names.isEmpty()) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("More than one Configuration Manager was found in the kernel");
        }
        AbstractName configurationManagerName = names.iterator().next();
        return kernel.getProxyManager().createProxy(configurationManagerName, EditableConfigurationManager.class);
    }

    public static void releaseConfigurationManager(Kernel kernel, ConfigurationManager configurationManager) {
    }

    static void preprocessGBeanData(AbstractName configurationName, Configuration configuration, GBeanData gbeanData) throws InvalidConfigException {
        if (log.isDebugEnabled()) {
            log.debug("resolving dependencies for " + gbeanData.getAbstractName());
        }
        for (String referenceName : gbeanData.getReferencesNames()) {
            AbstractName abstractName;
            GReferenceInfo referenceInfo = gbeanData.getGBeanInfo().getReference(referenceName);
            if (referenceInfo == null) {
                throw new InvalidConfigException("No reference named " + referenceName + " in gbean " + gbeanData.getAbstractName());
            }
            boolean isSingleValued = !referenceInfo.getProxyType().equals(Collection.class.getName());
            if (!isSingleValued) continue;
            ReferencePatterns referencePatterns = gbeanData.getReferencePatterns(referenceName);
            try {
                abstractName = configuration.findGBean(referencePatterns);
                if (log.isDebugEnabled()) {
                    log.debug("referencePatterns: " + referencePatterns + " resolved to " + abstractName);
                }
            }
            catch (GBeanNotFoundException e) {
                throw new InvalidConfigException("Unable to resolve reference \"" + referenceName + "\" in gbean " + gbeanData.getAbstractName() + " to a gbean matching the pattern " + referencePatterns, e);
            }
            gbeanData.setReferencePatterns(referenceName, new ReferencePatterns(abstractName));
        }
        HashSet<ReferencePatterns> newDependencies = new HashSet<ReferencePatterns>();
        for (ReferencePatterns referencePatterns : gbeanData.getDependencies()) {
            AbstractName abstractName;
            try {
                abstractName = configuration.findGBean(referencePatterns);
                if (log.isDebugEnabled()) {
                    log.debug("referencePatterns: " + referencePatterns + " resolved to " + abstractName);
                }
            }
            catch (GBeanNotFoundException e) {
                throw new InvalidConfigException("Unable to resolve dependency in gbean " + gbeanData.getAbstractName(), e);
            }
            newDependencies.add(new ReferencePatterns(abstractName));
        }
        gbeanData.setDependencies(newDependencies);
        gbeanData.addDependency(configurationName);
    }

    static void startConfigurationGBeans(AbstractName configurationName, Configuration configuration, Kernel kernel) throws InvalidConfigException {
        ArrayList<GBeanData> gbeans = new ArrayList<GBeanData>(configuration.getGBeans().values());
        Collections.sort(gbeans, new GBeanData.PriorityComparator());
        ArrayList<AbstractName> loaded = new ArrayList<AbstractName>(gbeans.size());
        ArrayList<AbstractName> started = new ArrayList<AbstractName>(gbeans.size());
        try {
            for (GBeanData gbeanData : gbeans) {
                gbeanData = new GBeanData(gbeanData);
                ConfigurationUtil.preprocessGBeanData(configurationName, configuration, gbeanData);
                try {
                    kernel.loadGBean(gbeanData, configuration.getBundleContext());
                    loaded.add(gbeanData.getAbstractName());
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new InvalidConfigException(e);
                }
                catch (Throwable e) {
                    log.warn("Could not load gbean " + gbeanData.getAbstractName(), e);
                    throw e;
                }
            }
            try {
                for (GBeanData gbeanData : gbeans) {
                    AbstractName gbeanName = gbeanData.getAbstractName();
                    kernel.startRecursiveGBean(gbeanName);
                    started.add(gbeanName);
                }
                ArrayList<String> unstarted = new ArrayList<String>();
                for (GBeanData gbeanData : gbeans) {
                    AbstractName gbeanName = gbeanData.getAbstractName();
                    if (1 == kernel.getGBeanState(gbeanName)) continue;
                    String stateReason = null;
                    if (kernel instanceof BasicKernel) {
                        stateReason = ((BasicKernel)kernel).getStateReason(gbeanName);
                    }
                    String name = gbeanName.toURI().getQuery();
                    if (stateReason != null) {
                        unstarted.add("The service " + name + " did not start because " + stateReason);
                        continue;
                    }
                    unstarted.add("The service " + name + " did not start for an unknown reason");
                }
                if (!unstarted.isEmpty()) {
                    StringBuffer message = new StringBuffer();
                    message.append("Configuration ").append(configuration.getId()).append(" failed to start due to the following reasons:\n");
                    for (String reason : unstarted) {
                        message.append("  ").append(reason).append("\n");
                    }
                    throw new InvalidConfigurationException(message.toString());
                }
            }
            catch (GBeanNotFoundException e) {
                throw new InvalidConfigException(e);
            }
            for (Configuration childConfiguration : configuration.getChildren()) {
                ConfigurationUtil.startConfigurationGBeans(configurationName, childConfiguration, kernel);
            }
        }
        catch (Throwable e) {
            for (AbstractName gbeanName : started) {
                try {
                    kernel.stopGBean(gbeanName);
                }
                catch (GBeanNotFoundException ignored) {
                }
                catch (IllegalStateException ignored) {
                }
                catch (InternalKernelException kernelException) {
                    log.debug("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName, (Throwable)kernelException);
                }
            }
            for (AbstractName gbeanName : loaded) {
                try {
                    kernel.unloadGBean(gbeanName);
                }
                catch (GBeanNotFoundException ignored) {
                }
                catch (IllegalStateException ignored) {
                }
                catch (InternalKernelException kernelException) {
                    log.debug("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName, (Throwable)kernelException);
                }
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof InvalidConfigException) {
                throw (InvalidConfigException)e;
            }
            throw new InvalidConfigException("Unknown start exception", e);
        }
    }

    static {
        ConfigurationMarshaler marshaler = null;
        String marshalerClass = System.getProperty("Xorg.apache.geronimo.kernel.config.Marshaler");
        if (marshalerClass != null) {
            try {
                marshaler = ConfigurationUtil.createConfigurationMarshaler(marshalerClass);
            }
            catch (Exception e) {
                log.error("Error creating configuration marshaler class " + marshalerClass, (Throwable)e);
            }
        }
        if (marshaler == null) {
            marshaler = new SerializedConfigurationMarshaler();
        }
        configurationMarshaler = marshaler;
    }
}

