/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.InstanceRegistry;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

public class BasicRegistry
implements InstanceRegistry {
    private final Map<ObjectName, GBeanInstance> objectNameRegistry = new HashMap<ObjectName, GBeanInstance>();
    private final Map<AbstractName, GBeanInstance> infoRegistry = new HashMap<AbstractName, GBeanInstance>();
    private final IdentityHashMap<Object, GBeanInstance> instanceRegistry = new IdentityHashMap();
    private String kernelName = "";

    public void start(Kernel kernel) {
        this.kernelName = kernel.getKernelName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            this.objectNameRegistry.clear();
        }
        this.kernelName = "";
    }

    public synchronized boolean isRegistered(ObjectName name) {
        return this.objectNameRegistry.containsKey(this.normalizeObjectName(name));
    }

    public synchronized boolean isRegistered(AbstractName refInfo) {
        return this.infoRegistry.containsKey(refInfo);
    }

    public synchronized void register(GBeanInstance gbeanInstance) throws GBeanAlreadyExistsException {
        ObjectName name = this.normalizeObjectName(gbeanInstance.getObjectNameObject());
        if (this.objectNameRegistry.containsKey(name)) {
            throw new GBeanAlreadyExistsException("GBean already registered: " + name);
        }
        this.objectNameRegistry.put(name, gbeanInstance);
        this.infoRegistry.put(gbeanInstance.getAbstractName(), gbeanInstance);
        gbeanInstance.setInstanceRegistry(this);
    }

    public synchronized void unregister(AbstractName abstractName) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.infoRegistry.remove(abstractName);
        if (gbeanInstance == null) {
            throw new GBeanNotFoundException(abstractName);
        }
        this.objectNameRegistry.remove(gbeanInstance.getObjectNameObject());
    }

    @Override
    public synchronized void instanceCreated(Object instance, GBeanInstance gbeanInstance) {
        this.instanceRegistry.put(instance, gbeanInstance);
    }

    @Override
    public synchronized void instanceDestroyed(Object instance) {
        this.instanceRegistry.remove(instance);
    }

    public synchronized GBeanInstance getGBeanInstanceByInstance(Object instance) {
        return this.instanceRegistry.get(instance);
    }

    public synchronized GBeanInstance getGBeanInstance(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance instance = this.objectNameRegistry.get(this.normalizeObjectName(name));
        if (instance == null) {
            throw new GBeanNotFoundException(name);
        }
        return instance;
    }

    public synchronized GBeanInstance getGBeanInstance(AbstractName abstractName) throws GBeanNotFoundException {
        GBeanInstance instance = this.infoRegistry.get(abstractName);
        if (instance == null) {
            throw new GBeanNotFoundException(abstractName);
        }
        return instance;
    }

    public synchronized GBeanInstance getGBeanInstance(String shortName, Class type) throws GBeanNotFoundException {
        if (shortName == null && type == null) {
            throw new IllegalArgumentException("shortName and type are both null");
        }
        AbstractNameQuery nameQuery = type == null ? new AbstractNameQuery(null, Collections.singletonMap("name", shortName)) : (shortName == null ? new AbstractNameQuery(null, Collections.EMPTY_MAP, type.getName()) : new AbstractNameQuery(null, Collections.singletonMap("name", shortName), type.getName()));
        Set<GBeanInstance> instances = this.listGBeans(nameQuery);
        if (instances.size() == 0) {
            throw new GBeanNotFoundException("No GBeans found", Collections.singleton(nameQuery), null);
        }
        if (instances.size() > 1) {
            if (type == null) {
                throw new GBeanNotFoundException("More then one GBean was found with shortName '" + shortName + "'", Collections.singleton(nameQuery), this.mapToNames(instances));
            }
            if (shortName == null) {
                throw new GBeanNotFoundException("More then one GBean was found with type '" + type.getName() + "'", Collections.singleton(nameQuery), this.mapToNames(instances));
            }
            throw new GBeanNotFoundException("More then one GBean was found with shortName '" + shortName + "' and type '" + type.getName() + "'", Collections.singleton(nameQuery), this.mapToNames(instances));
        }
        return instances.iterator().next();
    }

    private Set<AbstractName> mapToNames(Set<GBeanInstance> instances) {
        HashSet<AbstractName> names = new HashSet<AbstractName>(instances.size());
        for (GBeanInstance instance : instances) {
            names.add(instance.getAbstractName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GBeanInstance> listGBeans(ObjectName pattern) {
        HashMap<ObjectName, GBeanInstance> clone;
        pattern = this.normalizeObjectName(pattern);
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            clone = new HashMap<ObjectName, GBeanInstance>(this.objectNameRegistry);
        }
        HashSet<GBeanInstance> result = new HashSet<GBeanInstance>(clone.size());
        for (Map.Entry entry : clone.entrySet()) {
            ObjectName name = (ObjectName)entry.getKey();
            if (pattern != null && !pattern.apply(name)) continue;
            result.add((GBeanInstance)entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GBeanInstance> listGBeans(AbstractNameQuery query) {
        HashMap<AbstractName, GBeanInstance> clone;
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            clone = new HashMap<AbstractName, GBeanInstance>(this.infoRegistry);
        }
        HashSet<GBeanInstance> result = new HashSet<GBeanInstance>(clone.size());
        for (Map.Entry entry : clone.entrySet()) {
            AbstractName abstractName = (AbstractName)entry.getKey();
            GBeanInstance gbeanData = (GBeanInstance)entry.getValue();
            if (query != null && !query.matches(abstractName, gbeanData.getGBeanInfo().getInterfaces())) continue;
            result.add(gbeanData);
        }
        return result;
    }

    private ObjectName normalizeObjectName(ObjectName objectName) {
        if (objectName != null && objectName.getDomain().length() == 0) {
            try {
                return new ObjectName(this.kernelName, objectName.getKeyPropertyList());
            }
            catch (MalformedObjectNameException e) {
                throw new AssertionError((Object)e);
            }
        }
        return objectName;
    }
}

