/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;

public class BasicDependencyManager
implements DependencyManager {
    private final LifecycleMonitor lifecycleMonitor;
    private final LifecycleListener lifecycleListener = new DependencyManagerLifecycleListener();
    private final Map childToParentMap = new HashMap();
    private final Map parentToChildMap = new HashMap();

    public BasicDependencyManager(LifecycleMonitor lifecycleMonitor) throws Exception {
        assert (lifecycleMonitor != null);
        this.lifecycleMonitor = lifecycleMonitor;
        lifecycleMonitor.addLifecycleListener(this.lifecycleListener, new AbstractNameQuery(null, Collections.EMPTY_MAP, Collections.EMPTY_SET));
    }

    @Override
    public synchronized void close() {
        this.lifecycleMonitor.removeLifecycleListener(this.lifecycleListener);
        this.childToParentMap.clear();
        this.parentToChildMap.clear();
    }

    @Override
    public synchronized void addDependency(AbstractName child, AbstractName parent) {
        HashSet<AbstractName> parents = (HashSet<AbstractName>)this.childToParentMap.get(child);
        if (parents == null) {
            parents = new HashSet<AbstractName>();
            this.childToParentMap.put(child, parents);
        }
        parents.add(parent);
        HashSet<AbstractName> children = (HashSet<AbstractName>)this.parentToChildMap.get(parent);
        if (children == null) {
            children = new HashSet<AbstractName>();
            this.parentToChildMap.put(parent, children);
        }
        children.add(child);
    }

    @Override
    public synchronized void removeDependency(AbstractName child, AbstractName parent) {
        Set children;
        Set parents = (Set)this.childToParentMap.get(child);
        if (parents != null) {
            parents.remove(parent);
        }
        if ((children = (Set)this.parentToChildMap.get(parent)) != null) {
            children.remove(child);
        }
    }

    @Override
    public synchronized void removeAllDependencies(AbstractName child) {
        Set parents = (Set)this.childToParentMap.remove(child);
        if (parents == null) {
            return;
        }
        for (ObjectName parent : parents) {
            Set children = (Set)this.parentToChildMap.get(parent);
            if (children == null) continue;
            children.remove(child);
        }
    }

    @Override
    public synchronized void addDependencies(AbstractName child, Set parents) {
        HashSet existingParents = (HashSet)this.childToParentMap.get(child);
        if (existingParents == null) {
            existingParents = new HashSet(parents);
            this.childToParentMap.put(child, existingParents);
        } else {
            existingParents.addAll(parents);
        }
        for (Object startParent : parents) {
            HashSet<AbstractName> children = (HashSet<AbstractName>)this.parentToChildMap.get(startParent);
            if (children == null) {
                children = new HashSet<AbstractName>();
                this.parentToChildMap.put(startParent, children);
            }
            children.add(child);
        }
    }

    @Override
    public synchronized Set getParents(AbstractName child) {
        Set parents = (Set)this.childToParentMap.get(child);
        if (parents == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(parents);
    }

    @Override
    public synchronized Set getChildren(AbstractName parent) {
        Set children = (Set)this.parentToChildMap.get(parent);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(children);
    }

    private class DependencyManagerLifecycleListener
    extends LifecycleAdapter {
        private DependencyManagerLifecycleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unloaded(AbstractName abstractName) {
            BasicDependencyManager basicDependencyManager = BasicDependencyManager.this;
            synchronized (basicDependencyManager) {
                BasicDependencyManager.this.removeAllDependencies(abstractName);
            }
        }
    }
}

