/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.repository.Artifact;

public class Jsr77Naming
extends Naming {
    private static final String DEFAULT_DOMAIN_NAME = "geronimo";
    private static final String DEFAULT_SERVER_NAME = "geronimo";
    public static final String J2EE_TYPE = "j2eeType";
    public static final String J2EE_NAME = "name";
    private static final String INVALID_GENERIC_PARENT_TYPE = "GBean";

    @Override
    public AbstractName createRootName(Artifact artifact, String name, String type) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put(J2EE_TYPE, type);
        nameMap.put(J2EE_NAME, name);
        return new AbstractName(artifact, nameMap, Jsr77Naming.createObjectName(nameMap));
    }

    @Override
    public AbstractName createChildName(AbstractName parentAbstractName, String name, String type) {
        return this.createChildName(parentAbstractName, parentAbstractName.getArtifact(), name, type);
    }

    @Override
    public AbstractName createSiblingName(AbstractName parentAbstractName, String name, String type) {
        HashMap<String, String> nameMap = new HashMap<String, String>(parentAbstractName.getName());
        nameMap.put(J2EE_TYPE, type);
        nameMap.put(J2EE_NAME, name);
        return new AbstractName(parentAbstractName.getArtifact(), nameMap, Jsr77Naming.createObjectName(nameMap));
    }

    @Override
    public AbstractName createChildName(AbstractName parentAbstractName, Artifact artifact, String name, String type) {
        if (name == null) {
            throw new NullPointerException("No name supplied");
        }
        if (type == null) {
            throw new NullPointerException("No type supplied");
        }
        HashMap<String, String> nameMap = new HashMap<String, String>(parentAbstractName.getName());
        String parentType = (String)nameMap.remove(J2EE_TYPE);
        String parentName = (String)nameMap.remove(J2EE_NAME);
        if (parentType == null) {
            throw new IllegalArgumentException("parent name must have a j2eeType name component");
        }
        if (INVALID_GENERIC_PARENT_TYPE.equals(parentType)) {
            throw new IllegalArgumentException("You can't create a child of a generic typed gbean");
        }
        nameMap.put(parentType, parentName);
        nameMap.put(J2EE_TYPE, type);
        nameMap.put(J2EE_NAME, name);
        return new AbstractName(artifact, nameMap, Jsr77Naming.createObjectName(nameMap));
    }

    public static ObjectName createObjectName(Map nameMap) {
        ObjectName moduleObjectName;
        Hashtable<String, String> objectNameMap = new Hashtable<String, String>(nameMap);
        String type = (String)nameMap.get(J2EE_TYPE);
        if ("JVM".equals(type)) {
            objectNameMap.keySet().retainAll(Arrays.asList(J2EE_TYPE, J2EE_NAME, "J2EEServer"));
            objectNameMap.put("J2EEServer", "geronimo");
        } else if ("J2EEDomain".equals(type)) {
            objectNameMap.clear();
            objectNameMap.put(J2EE_TYPE, "J2EEDomain");
            objectNameMap.put(J2EE_NAME, "geronimo");
        } else if ("J2EEServer".equals(type)) {
            objectNameMap.clear();
            objectNameMap.put(J2EE_TYPE, "J2EEServer");
            objectNameMap.put(J2EE_NAME, "geronimo");
        } else {
            objectNameMap.put("J2EEServer", "geronimo");
        }
        try {
            moduleObjectName = ObjectName.getInstance("geronimo", objectNameMap);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
        return moduleObjectName;
    }
}

