/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.spi.ModuleConfigurer;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.plugin.ServerArchiver;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtendedDeploymentManager
extends JMXDeploymentManager
implements GeronimoDeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(ExtendedDeploymentManager.class);

    public ExtendedDeploymentManager(Collection<ModuleConfigurer> moduleConfigurers) {
        super(moduleConfigurers);
    }

    @Override
    public <T> T getImplementation(Class<T> clazz) {
        try {
            return this.kernel.getGBean(clazz);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("No implementation for " + clazz.getName(), e);
        }
    }

    protected <T> T getImplementation(AbstractName name, Class<T> clazz) {
        try {
            return clazz.cast(this.kernel.getGBean(name));
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("No implementation for " + clazz.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginListType listPlugins(URL mavenRepository) throws FailedLoginException, IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginListType pluginListType = installer.listPlugins(mavenRepository);
            return pluginListType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validatePlugin(PluginType plugin) throws MissingDependencyException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            boolean bl = installer.validatePlugin(plugin);
            return bl;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dependency[] checkPrerequisites(PluginType plugin) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Dependency[] dependencyArray = installer.checkPrerequisites(plugin);
            return dependencyArray;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadResults install(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.install(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.install(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password, poller);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object startInstall(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Object object = installer.startInstall(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password);
            return object;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object startInstall(File carFile, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Object object = installer.startInstall(carFile, defaultRepository, restrictToDefaultRepository, username, password);
            return object;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadResults checkOnInstall(Object key) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.checkOnInstall(key);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadResults checkOnInstall(Object key, boolean remove) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.checkOnInstall(key, remove);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    private PluginInstaller getPluginInstaller() {
        return this.getImplementation(PluginInstaller.class);
    }

    private ServerArchiver getServerArchiver() {
        return this.getImplementation(ServerArchiver.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginListType createPluginListForRepositories(String repo) throws NoSuchStoreException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginListType pluginListType = installer.createPluginListForRepositories(repo);
            return pluginListType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Artifact> getInstalledPlugins() {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Map<String, Artifact> map = installer.getInstalledPlugins();
            return map;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginType getPluginMetadata(Artifact configId) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginType pluginType = installer.getPluginMetadata(configId);
            return pluginType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePluginMetadata(PluginType metadata) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.updatePluginMetadata(metadata);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL[] getRepositories() {
        ArrayList<URL> list = new ArrayList<URL>();
        Set<AbstractName> set = this.kernel.listGBeans(new AbstractNameQuery(PluginRepositoryList.class.getName()));
        for (AbstractName name : set) {
            PluginRepositoryList repo = this.getImplementation(name, PluginRepositoryList.class);
            try {
                list.addAll(repo.getRepositories());
            }
            finally {
                this.kernel.getProxyManager().destroyProxy(repo);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Artifact installLibrary(File libFile, String groupId) throws IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Artifact artifact = installer.installLibrary(libFile, groupId);
            return artifact;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadResults installPluginList(String targetRepositoryPath, String relativeTargetServerPath, PluginListType pluginList) throws Exception {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.installPluginList(targetRepositoryPath, relativeTargetServerPath, pluginList);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeOverrides(String server, AttributesType overrides) throws InvalidGBeanException, IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.mergeOverrides(server, overrides);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File archive(String sourcePath, String destPath, Artifact artifact) throws IOException {
        ServerArchiver archiver = this.getServerArchiver();
        try {
            File file = archiver.archive(sourcePath, destPath, artifact);
            return file;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy(archiver);
        }
    }
}

