/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.spec.SecretKeySpec;
import org.apache.geronimo.crypto.Encryption;
import org.apache.geronimo.crypto.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEncryption
implements Encryption {
    private static final Logger log = LoggerFactory.getLogger(AbstractEncryption.class);

    public String encrypt(Serializable source) {
        SecretKeySpec spec = this.getSecretKeySpec();
        try {
            Cipher c = Cipher.getInstance(spec.getAlgorithm());
            c.init(1, spec);
            SealedObject so = new SealedObject(source, c);
            ByteArrayOutputStream store = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(store);
            out.writeObject(so);
            out.close();
            byte[] data = store.toByteArray();
            byte[] textData = Base64.encode(data);
            return new String(textData, "US-ASCII");
        }
        catch (Exception e) {
            log.error("Unable to encrypt", (Throwable)e);
            return null;
        }
    }

    public Serializable decrypt(String source) {
        SecretKeySpec spec = this.getSecretKeySpec();
        try {
            byte[] data = Base64.decode(source);
            Cipher c = Cipher.getInstance(spec.getAlgorithm());
            c.init(2, spec);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
            SealedObject so = (SealedObject)in.readObject();
            return (Serializable)so.getObject(c);
        }
        catch (Exception e) {
            log.error("Unable to decrypt", (Throwable)e);
            return null;
        }
    }

    protected abstract SecretKeySpec getSecretKeySpec();
}

