/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.geronimo.config.converters.MicroProfileTypedConverter;
import org.eclipse.microprofile.config.spi.Converter;

public abstract class ImplicitConverter {
    public static <T> MicroProfileTypedConverter<T> getImplicitConverter(Class<T> clazz) {
        Converter<T> converter = ImplicitConverter.hasConverterCt(clazz, String.class);
        if (converter == null) {
            converter = ImplicitConverter.hasConverterCt(clazz, CharSequence.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "valueOf", String.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "valueOf", CharSequence.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "parse", String.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "parse", CharSequence.class);
        }
        if (converter == null) {
            return null;
        }
        return new MicroProfileTypedConverter<T>(converter, 100);
    }

    private static <T> Converter<T> hasConverterCt(Class<T> clazz, Class<?> paramType) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(paramType);
            if (!declaredConstructor.isAccessible()) {
                declaredConstructor.setAccessible(true);
            }
            return value -> {
                try {
                    return declaredConstructor.newInstance(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static <T> Converter<T> hasConverterMethod(Class<T> clazz, String methodName, Class<?> paramType) {
        try {
            Method method = clazz.getMethod(methodName, paramType);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return value -> {
                    try {
                        return method.invoke(null, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

