/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.ConfigImpl;
import org.apache.geronimo.config.DefaultConfigProvider;
import org.apache.geronimo.config.configsource.BaseConfigSource;
import org.apache.geronimo.config.configsource.PropertyFileConfigSourceProvider;
import org.apache.geronimo.config.configsource.SystemEnvConfigSource;
import org.apache.geronimo.config.configsource.SystemPropertyConfigSource;
import org.apache.geronimo.config.converters.BooleanConverter;
import org.apache.geronimo.config.converters.ClassConverter;
import org.apache.geronimo.config.converters.DoubleConverter;
import org.apache.geronimo.config.converters.DurationConverter;
import org.apache.geronimo.config.converters.FloatConverter;
import org.apache.geronimo.config.converters.InstantConverter;
import org.apache.geronimo.config.converters.IntegerConverter;
import org.apache.geronimo.config.converters.LocalDateConverter;
import org.apache.geronimo.config.converters.LocalDateTimeConverter;
import org.apache.geronimo.config.converters.LocalTimeConverter;
import org.apache.geronimo.config.converters.LongConverter;
import org.apache.geronimo.config.converters.MicroProfileTypedConverter;
import org.apache.geronimo.config.converters.OffsetDateTimeConverter;
import org.apache.geronimo.config.converters.OffsetTimeConverter;
import org.apache.geronimo.config.converters.StringConverter;
import org.apache.geronimo.config.converters.URLConverter;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

@Typed
@Vetoed
public class DefaultConfigBuilder
implements ConfigBuilder {
    private ClassLoader forClassLoader;
    private final List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private boolean ignoreDefaultSources = true;
    private boolean ignoreDiscoveredSources = true;
    private boolean ignoreDiscoveredConverters = true;
    private final Map<Type, MicroProfileTypedConverter<?>> registeredConverters = new HashMap();

    public DefaultConfigBuilder() {
        this.registerDefaultConverters();
    }

    public ConfigBuilder addDefaultSources() {
        this.ignoreDefaultSources = false;
        return this;
    }

    public ConfigBuilder addDiscoveredSources() {
        this.ignoreDiscoveredSources = false;
        return this;
    }

    public ConfigBuilder forClassLoader(ClassLoader loader) {
        this.forClassLoader = loader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... sources) {
        this.sources.addAll(Arrays.asList(sources));
        return this;
    }

    public ConfigBuilder withConverters(Converter<?> ... converters) {
        for (Converter<?> converter : converters) {
            Type typeOfConverter = this.getTypeOfConverter(converter.getClass());
            this.registerConverter(typeOfConverter, new MicroProfileTypedConverter(converter));
        }
        return this;
    }

    public <T> ConfigBuilder withConverter(Class<T> type, int priority, Converter<T> converter) {
        MicroProfileTypedConverter<T> microProfileTypedConverter = new MicroProfileTypedConverter<T>(converter, priority);
        return this.registerConverter(type, microProfileTypedConverter);
    }

    private <T> ConfigBuilder registerConverter(Type type, MicroProfileTypedConverter<T> microProfileTypedConverter) {
        MicroProfileTypedConverter<?> existing = this.registeredConverters.get(type);
        if (existing == null || microProfileTypedConverter.getPriority() > existing.getPriority()) {
            this.registeredConverters.put(type, microProfileTypedConverter);
        }
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        this.ignoreDiscoveredConverters = false;
        return this;
    }

    public Config build() {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        if (this.forClassLoader == null) {
            this.forClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.forClassLoader == null) {
                this.forClassLoader = DefaultConfigProvider.class.getClassLoader();
            }
        }
        if (!this.ignoreDefaultSources) {
            configSources.addAll(this.getBuiltInConfigSources(this.forClassLoader));
        }
        configSources.addAll(this.sources);
        if (!this.ignoreDiscoveredSources) {
            ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.forClassLoader);
            configSourceLoader.forEach(configSources::add);
            ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.forClassLoader);
            configSourceProviderLoader.forEach(configSourceProvider -> configSourceProvider.getConfigSources(this.forClassLoader).forEach(configSources::add));
        }
        if (!this.ignoreDiscoveredConverters) {
            ServiceLoader<Converter> converterLoader = ServiceLoader.load(Converter.class, this.forClassLoader);
            converterLoader.forEach(xva$0 -> this.withConverters((Converter<?>)xva$0));
        }
        ConfigImpl config = new ConfigImpl();
        config.addConfigSources(configSources);
        for (Map.Entry<Type, MicroProfileTypedConverter<?>> entry : this.registeredConverters.entrySet()) {
            config.addConverter(entry.getKey(), entry.getValue());
        }
        return config;
    }

    protected Collection<? extends ConfigSource> getBuiltInConfigSources(ClassLoader forClassLoader) {
        ArrayList<BaseConfigSource> configSources = new ArrayList<BaseConfigSource>();
        configSources.add(new SystemEnvConfigSource());
        configSources.add(new SystemPropertyConfigSource());
        configSources.addAll((Collection<BaseConfigSource>)new PropertyFileConfigSourceProvider("/META-INF/microprofile-config.properties", true, forClassLoader).getConfigSources(forClassLoader));
        return configSources;
    }

    private void registerDefaultConverters() {
        this.registeredConverters.put((Type)((Object)String.class), new MicroProfileTypedConverter<String>(StringConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Boolean.class), new MicroProfileTypedConverter<Boolean>(BooleanConverter.INSTANCE));
        this.registeredConverters.put(Boolean.TYPE, new MicroProfileTypedConverter<Boolean>(BooleanConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Double.class), new MicroProfileTypedConverter<Double>(DoubleConverter.INSTANCE));
        this.registeredConverters.put(Double.TYPE, new MicroProfileTypedConverter<Double>(DoubleConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Float.class), new MicroProfileTypedConverter<Float>(FloatConverter.INSTANCE));
        this.registeredConverters.put(Float.TYPE, new MicroProfileTypedConverter<Float>(FloatConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Integer.class), new MicroProfileTypedConverter<Integer>(IntegerConverter.INSTANCE));
        this.registeredConverters.put(Integer.TYPE, new MicroProfileTypedConverter<Integer>(IntegerConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Long.class), new MicroProfileTypedConverter<Long>(LongConverter.INSTANCE));
        this.registeredConverters.put(Long.TYPE, new MicroProfileTypedConverter<Long>(LongConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Duration.class), new MicroProfileTypedConverter<Duration>(DurationConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)LocalTime.class), new MicroProfileTypedConverter<LocalTime>(LocalTimeConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)LocalDate.class), new MicroProfileTypedConverter<LocalDate>(LocalDateConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)LocalDateTime.class), new MicroProfileTypedConverter<LocalDateTime>(LocalDateTimeConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)OffsetTime.class), new MicroProfileTypedConverter<OffsetTime>(OffsetTimeConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)OffsetDateTime.class), new MicroProfileTypedConverter<OffsetDateTime>(OffsetDateTimeConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Instant.class), new MicroProfileTypedConverter<Instant>(InstantConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)URL.class), new MicroProfileTypedConverter<URL>(URLConverter.INSTANCE));
        this.registeredConverters.put((Type)((Object)Class.class), new MicroProfileTypedConverter<Class>(ClassConverter.INSTANCE));
    }

    private Type getTypeOfConverter(Class clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be a ParameterisedType");
            }
            return typeArguments[0];
        }
        return this.getTypeOfConverter(clazz.getSuperclass());
    }
}

