/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.ConfigValueImpl;
import org.apache.geronimo.config.converters.ImplicitArrayConverter;
import org.apache.geronimo.config.converters.ImplicitConverter;
import org.apache.geronimo.config.converters.MicroProfileTypedConverter;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Typed
@Vetoed
public class ConfigImpl
implements Config {
    protected Logger logger = Logger.getLogger(ConfigImpl.class.getName());
    protected final List<ConfigSource> configSources = new ArrayList<ConfigSource>();
    protected final ConcurrentMap<Type, MicroProfileTypedConverter> converters = new ConcurrentHashMap<Type, MicroProfileTypedConverter>();
    private static final String ARRAY_SEPARATOR_REGEX = "(?<!\\\\)" + Pattern.quote(",");
    private final ImplicitArrayConverter implicitArrayConverter = new ImplicitArrayConverter(this);

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> asType) {
        String value = this.getValue(propertyName);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return Optional.ofNullable(this.convert(value, asType));
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        String value = this.getValue(propertyName);
        if (value == null) {
            throw new NoSuchElementException("No configured value found for config key " + propertyName);
        }
        return this.convert(value, propertyType);
    }

    public String getValue(String key) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(key);
            if (value == null) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{value, key, configSource.getName()});
            }
            return value;
        }
        return null;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            return this.getConverter(asType).convert(value);
        }
        return null;
    }

    public <T> List<T> convertList(String rawValue, Class<T> arrayElementType) {
        MicroProfileTypedConverter<T> converter = this.getConverter(arrayElementType);
        String[] parts = rawValue.split(ARRAY_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> elements = new ArrayList<T>(parts.length);
        for (String part : parts) {
            part = part.replace("\\,", ",");
            T converted = converter.convert(part);
            elements.add(converted);
        }
        return elements;
    }

    private <T> MicroProfileTypedConverter<T> getConverter(Class<T> asType) {
        MicroProfileTypedConverter microProfileTypedConverter = this.converters.computeIfAbsent(asType, a -> this.handleMissingConverter(asType));
        if (microProfileTypedConverter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return microProfileTypedConverter;
    }

    private <T> MicroProfileTypedConverter<T> handleMissingConverter(Class<T> asType) {
        if (asType.isArray()) {
            return new MicroProfileTypedConverter(value -> this.implicitArrayConverter.convert(value, asType));
        }
        return ImplicitConverter.getImplicitConverter(asType);
    }

    public ConfigValueImpl<String> access(String key) {
        return new ConfigValueImpl<String>(this, key);
    }

    public Iterable<String> getPropertyNames() {
        return this.configSources.stream().flatMap(c -> c.getPropertyNames().stream()).collect(Collectors.toSet());
    }

    public Iterable<ConfigSource> getConfigSources() {
        return Collections.unmodifiableList(this.configSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>(this.configSources);
        allConfigSources.addAll(configSourcesToAdd);
        List<ConfigSource> list = this.configSources;
        synchronized (list) {
            this.configSources.clear();
            this.configSources.addAll(this.sortDescending(allConfigSources));
        }
    }

    public Map<Type, MicroProfileTypedConverter> getConverters() {
        return this.converters;
    }

    private List<ConfigSource> sortDescending(List<ConfigSource> configSources) {
        configSources.sort((configSource1, configSource2) -> configSource1.getOrdinal() > configSource2.getOrdinal() ? -1 : 1);
        return configSources;
    }

    public void addConverter(Type type, MicroProfileTypedConverter<?> converter) {
        this.converters.put(type, converter);
    }
}

