/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.RetryScheduler;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CommitTask.class);
    private final Xid xid;
    private final List<TransactionImpl.TransactionBranch> rms;
    private final Object logMark;
    private final RetryScheduler retryScheduler;
    private final TransactionLog txLog;
    private int count = 0;
    private int status;
    private XAException cause;
    private boolean evercommit;

    public CommitTask(Xid xid, List<TransactionImpl.TransactionBranch> rms, Object logMark, RetryScheduler retryScheduler, TransactionLog txLog) {
        this.xid = xid;
        this.rms = rms;
        this.logMark = logMark;
        this.retryScheduler = retryScheduler;
        this.txLog = txLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommitTask commitTask = this;
        synchronized (commitTask) {
            this.status = 8;
        }
        Object i = this.rms.iterator();
        while (i.hasNext()) {
            TransactionImpl.TransactionBranch manager = i.next();
            try {
                try {
                    manager.getCommitter().commit(manager.getBranchId(), false);
                    this.evercommit = true;
                    i.remove();
                }
                catch (XAException e) {
                    log.error("Unexpected exception committing " + manager.getCommitter() + "; continuing to commit other RMs", (Throwable)e);
                    if (e.errorCode == 6) {
                        i.remove();
                        log.info("Transaction has been heuristically rolled back");
                        this.cause = e;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 5) {
                        i.remove();
                        log.info("Transaction has been heuristically committed and rolled back");
                        this.cause = e;
                        this.evercommit = true;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 7) {
                        i.remove();
                        log.info("Transaction has been heuristically committed");
                        this.evercommit = true;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 4) continue;
                    i.remove();
                    this.cause = e;
                }
            }
            catch (XAException e) {
                if (e.errorCode == -4) continue;
                this.cause = e;
            }
        }
        if (this.rms.isEmpty() && this.status == 3) {
            try {
                this.txLog.commit(this.xid, this.logMark);
                i = this;
                synchronized (i) {
                    this.status = 3;
                }
            }
            catch (LogException e) {
                log.error("Unexpected exception logging commit completion for xid " + this.xid, (Throwable)e);
                this.cause = (XAException)new XAException("Unexpected error logging commit completion for xid " + this.xid).initCause(e);
            }
        } else {
            this.retryScheduler.retry(this, this.count++);
        }
    }

    public XAException getCause() {
        return this.cause;
    }

    public boolean isEvercommit() {
        return this.evercommit;
    }

    public int getStatus() {
        return this.status;
    }
}

