/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.KeyedObject;
import org.apache.geronimo.components.jaspi.model.ServerAuthContextType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="serverAuthConfigType", propOrder={"messageLayer", "appContext", "authenticationContextID", "_protected", "serverAuthContext"})
public class ServerAuthConfigType
implements Serializable,
KeyedObject {
    private static final long serialVersionUID = 12343L;
    protected String messageLayer;
    protected String appContext;
    protected String authenticationContextID;
    @XmlElement(name="protected")
    protected boolean _protected;
    protected List<ServerAuthContextType> serverAuthContext;

    public ServerAuthConfigType() {
    }

    public ServerAuthConfigType(ServerAuthContextType serverAuthContextType, boolean _protected) {
        this.messageLayer = serverAuthContextType.getMessageLayer();
        this.appContext = serverAuthContextType.getAppContext();
        this.authenticationContextID = serverAuthContextType.getAuthenticationContextID();
        this.serverAuthContext = Collections.singletonList(serverAuthContextType);
        this._protected = _protected;
    }

    public String getMessageLayer() {
        return this.messageLayer;
    }

    public void setMessageLayer(String value) {
        this.messageLayer = value;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) throws IllegalArgumentException {
        if (this.authenticationContextID != null) {
            return this.authenticationContextID;
        }
        for (ServerAuthContextType serverAuthContextType : this.serverAuthContext) {
            String authContextID = serverAuthContextType.getAuthenticationContextID(messageInfo);
            if (authContextID == null) continue;
            return authContextID;
        }
        return null;
    }

    public void setAppContext(String value) {
        this.appContext = value;
    }

    public String getAuthenticationContextID() {
        return this.authenticationContextID;
    }

    public void setAuthenticationContextID(String value) {
        this.authenticationContextID = value;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public void refresh() throws AuthException, SecurityException {
    }

    public void setProtected(boolean value) {
        this._protected = value;
    }

    public List<ServerAuthContextType> getServerAuthContext() {
        if (this.serverAuthContext == null) {
            this.serverAuthContext = new ArrayList<ServerAuthContextType>();
        }
        return this.serverAuthContext;
    }

    @Override
    public String getKey() {
        return ConfigProviderType.getRegistrationKey(this.messageLayer, this.appContext);
    }
}

