/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers.support;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginHandlerInterceptor
implements AsyncHandlerInterceptor,
ServletContextAware {
    private static final Logger logger = LogService.getLogger();
    private SecurityService securityService;
    private static final ThreadLocal<Map<String, String>> ENV = new /* Unavailable Anonymous Inner Class!! */;
    protected static final String ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX = "vf.gf.env.";
    protected static final String SECURITY_VARIABLE_REQUEST_HEADER_PREFIX = "security-";

    public LoginHandlerInterceptor() {
    }

    @VisibleForTesting
    LoginHandlerInterceptor(SecurityService securityService) {
        this.securityService = securityService;
    }

    public static Map<String, String> getEnvironment() {
        return (Map)ENV.get();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HashMap<String, String> requestParameterValues = new HashMap<String, String>();
        Enumeration requestParameters = request.getParameterNames();
        while (requestParameters.hasMoreElements()) {
            String requestParameter = (String)requestParameters.nextElement();
            if (!requestParameter.startsWith(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX)) continue;
            String requestValue = request.getParameter(requestParameter);
            requestParameterValues.put(requestParameter.substring(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX.length()), requestValue);
        }
        ENV.set(requestParameterValues);
        String token = request.getHeader("security-token");
        String username = request.getHeader("security-username");
        String password = request.getHeader("security-password");
        Properties credentials = new Properties();
        if (token != null) {
            credentials.put("security-token", token);
        } else {
            if (username != null) {
                credentials.put("security-username", username);
            }
            if (password != null) {
                credentials.put("security-password", password);
            }
        }
        this.securityService.login(credentials);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.afterConcurrentHandlingStarted(request, response, handler);
        this.securityService.logout();
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ENV.remove();
    }

    public void setServletContext(ServletContext servletContext) {
        this.securityService = (SecurityService)servletContext.getAttribute("org.apache.geode.securityService");
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }
}

