/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.security;

import java.util.Collection;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component
public class GeodeAuthenticationProvider
implements AuthenticationProvider,
ServletContextAware {
    private SecurityService securityService;

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        Properties credentials = new Properties();
        if (username != null) {
            credentials.put("security-username", username);
        }
        if (password != null) {
            credentials.put("security-password", password);
        }
        try {
            this.securityService.login(credentials);
            return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)AuthorityUtils.NO_AUTHORITIES);
        }
        catch (GemFireSecurityException e) {
            throw new BadCredentialsException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }

    public void setServletContext(ServletContext servletContext) {
        this.securityService = (SecurityService)servletContext.getAttribute("org.apache.geode.securityService");
    }
}

