/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class JwtAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public JwtAuthenticationFilter() {
        super("/**");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String header = request.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            throw new BadCredentialsException("No JWT token found in request headers, header: " + header);
        }
        String[] tokens = header.split(" ");
        if (tokens.length != 2) {
            throw new BadCredentialsException("Wrong authentication header format: " + header);
        }
        return new UsernamePasswordAuthenticationToken((Object)tokens[0], (Object)tokens[1]);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        super.successfulAuthentication(request, response, chain, authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

