/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geode.management.internal.rest.controllers.ManagementControllerAdvice;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ManagementLoggingFilter
extends OncePerRequestFilter {
    private static final Boolean ENABLE_REQUEST_LOGGING = Boolean.parseBoolean(System.getProperty("geode.management.request.logging", "false"));
    private static final int MAX_PAYLOAD_LENGTH = 10000;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.logger.isDebugEnabled() && !ENABLE_REQUEST_LOGGING.booleanValue()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ContentCachingRequestWrapper wrappedRequest = new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper wrappedResponse = new ContentCachingResponseWrapper(response);
        filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        if (!request.getRequestURI().contains("swagger") && !request.getRequestURI().contains("api-docs")) {
            this.logRequest(request, wrappedRequest);
            this.logResponse(response, wrappedResponse);
        }
        wrappedResponse.copyBodyToResponse();
    }

    private void logRequest(HttpServletRequest request, ContentCachingRequestWrapper wrappedRequest) {
        String requestPattern = "Management Request: %s[url=%s]; user=%s; payload=%s";
        String requestUrl = request.getRequestURI();
        if (request.getQueryString() != null) {
            requestUrl = requestUrl + "?" + request.getQueryString();
        }
        String payload = this.getContentAsString(wrappedRequest.getContentAsByteArray(), wrappedRequest.getCharacterEncoding());
        String message = String.format(requestPattern, request.getMethod(), requestUrl, request.getRemoteUser(), payload);
        this.logMessage(message);
    }

    private void logMessage(String message) {
        if (ENABLE_REQUEST_LOGGING.booleanValue()) {
            this.logger.info((Object)message);
        } else {
            this.logger.debug((Object)message);
        }
    }

    private void logResponse(HttpServletResponse response, ContentCachingResponseWrapper wrappedResponse) {
        String responsePattern = "Management Response: Status=%s; response=%s";
        String payload = this.getContentAsString(wrappedResponse.getContentAsByteArray(), wrappedResponse.getCharacterEncoding());
        String message = String.format(responsePattern, response.getStatus(), ManagementControllerAdvice.removeClassFromJsonText((String)payload));
        this.logMessage(message);
    }

    private String getContentAsString(byte[] buf, String encoding) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        int length = Math.min(buf.length, 10000);
        for (int i = 0; i < length; ++i) {
            if (buf[i] == 10 || buf[i] == 13 || buf[i] >= 32 && buf[i] <= 126) continue;
            buf[i] = 63;
        }
        try {
            return new String(buf, 0, length, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            return "[unknown]";
        }
    }
}

