/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ConfigurationResult;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.geode.management.runtime.RuntimeRegionInfo;
import org.apache.geode.security.ResourcePermission;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="regionManagement")
@RequestMapping(value={"/experimental"})
public class RegionManagementController
extends AbstractManagementController {
    @ApiOperation(value="create regions")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=409, message="Region already exist."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/regions"})
    public ResponseEntity<ClusterManagementResult> createRegion(@RequestBody RegionConfig regionConfig) {
        ClusterManagementRealizationResult result;
        return new ResponseEntity((Object)result, (result = this.clusterManagementService.create((CacheElement)regionConfig)).isSuccessful() ? HttpStatus.CREATED : HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/regions"})
    @ResponseBody
    public ClusterManagementListResult<RegionConfig, RuntimeRegionInfo> listRegion(@RequestParam(required=false) String id, @RequestParam(required=false) String group) {
        RegionConfig filter = new RegionConfig();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filter.setName(id);
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            filter.setGroup(group);
        }
        return this.clusterManagementService.list((CacheElement)filter);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/regions/{id}"})
    @ResponseBody
    public ClusterManagementListResult<RegionConfig, RuntimeRegionInfo> getRegion(@PathVariable(name="id") String id) {
        this.securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, id);
        RegionConfig config = new RegionConfig();
        config.setName(id);
        return this.clusterManagementService.get((CacheElement)config);
    }

    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/regions/{id}"})
    @ResponseBody
    public ClusterManagementResult deleteRegion(@PathVariable(name="id") String id, @RequestParam(required=false) String group) {
        RegionConfig config = new RegionConfig();
        config.setName(id);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            config.setGroup(group);
        }
        return this.clusterManagementService.delete((CacheElement)config);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/regions/{regionName}/indexes"})
    @ResponseBody
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ', 'QUERY')")
    public ClusterManagementListResult<RegionConfig.Index, RuntimeInfo> listIndex(@PathVariable String regionName, @RequestParam(required=false) String id) {
        ClusterManagementListResult<RegionConfig, RuntimeRegionInfo> result0 = this.getRegion(regionName);
        RegionConfig regionConfig = (RegionConfig)((ConfigurationResult)result0.getResult().get(0)).getConfig();
        List indexList = regionConfig.getIndexes().stream().map(e -> {
            if (StringUtils.isNotBlank((CharSequence)id) && !e.getId().equals(id)) {
                return null;
            }
            e.setRegionName(regionName);
            return e;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<ConfigurationResult> responses = new ArrayList<ConfigurationResult>();
        for (RegionConfig.Index index : indexList) {
            responses.add(new ConfigurationResult((CacheElement)index));
        }
        ClusterManagementListResult result = new ClusterManagementListResult();
        result.setResult(responses);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/regions/{regionName}/indexes/{id}"})
    @ResponseBody
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ', 'QUERY')")
    public ClusterManagementListResult<RegionConfig.Index, RuntimeInfo> getIndex(@PathVariable String regionName, @PathVariable String id) {
        ClusterManagementListResult<RegionConfig.Index, RuntimeInfo> result = this.listIndex(regionName, id);
        List indexList = result.getResult();
        if (indexList.size() == 0) {
            throw new ClusterManagementException(new ClusterManagementResult(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, "Index '" + id + "' does not exist in region '" + regionName + "'."));
        }
        if (indexList.size() > 1) {
            throw new ClusterManagementException(new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, "More than one index found."));
        }
        result.setResult(indexList);
        return result;
    }
}

