/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ManagementLoggingFilter
extends OncePerRequestFilter {
    private static final Boolean ENABLE_REQUEST_LOGGING = Boolean.parseBoolean(System.getProperty("geode.management.request.logging", "true"));
    private static int MAX_PAYLOAD_LENGTH = 10000;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!ENABLE_REQUEST_LOGGING.booleanValue()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ContentCachingRequestWrapper wrappedRequest = new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper wrappedResponse = new ContentCachingResponseWrapper(response);
        filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        if (!request.getRequestURI().contains("swagger") && !request.getRequestURI().contains("api-docs")) {
            this.logRequest(request, wrappedRequest);
            this.logResponse(response, wrappedResponse);
        }
        wrappedResponse.copyBodyToResponse();
    }

    private void logRequest(HttpServletRequest request, ContentCachingRequestWrapper wrappedRequest) {
        String requestPattern = "Management Request: %s[url=%s]; user=%s; payload=%s";
        String requestUrl = request.getRequestURI();
        if (request.getQueryString() != null) {
            requestUrl = requestUrl + "?" + request.getQueryString();
        }
        String payload = this.getContentAsString(wrappedRequest.getContentAsByteArray(), wrappedRequest.getCharacterEncoding());
        this.logger.info((Object)String.format(requestPattern, request.getMethod(), requestUrl, request.getRemoteUser(), payload));
    }

    private void logResponse(HttpServletResponse response, ContentCachingResponseWrapper wrappedResponse) {
        String responsePattern = "Management Response: Status=%s; response=%s";
        String payload = this.getContentAsString(wrappedResponse.getContentAsByteArray(), wrappedResponse.getCharacterEncoding());
        this.logger.info((Object)String.format(responsePattern, response.getStatus(), payload));
    }

    private String getContentAsString(byte[] buf, String encoding) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        int length = Math.min(buf.length, MAX_PAYLOAD_LENGTH);
        try {
            return new String(buf, 0, length, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            return "[unknown]";
        }
    }
}

