/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.wan.AbstractRemoteGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.cache.wan.parallel.RemoteConcurrentParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.logging.log4j.Logger;

public class ParallelGatewaySenderImpl
extends AbstractRemoteGatewaySender {
    private static final Logger logger = LogService.getLogger();

    public ParallelGatewaySenderImpl(InternalCache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    public void start() {
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn("Gateway Sender {} is already running", (Object)this.getId());
                return;
            }
            if (this.remoteDSId != -1 && (locators = this.cache.getInternalDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new IllegalStateException("Locators must be configured before starting gateway-sender.");
            }
            this.eventProcessor = new RemoteConcurrentParallelGatewaySenderEventProcessor(this, this.getThreadMonitorObj());
            this.eventProcessor.start();
            this.waitForRunningStatus();
            if (!this.isAsyncEventQueue()) {
                this.getCache().getPdxRegistry().gatewaySenderStarted((GatewaySender)this);
            }
            new UpdateAttributesProcessor((DistributionAdvisee)this).distribute(false);
            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, (Object)this);
            logger.info("Started {}", (Object)this);
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    public void stop() {
        this.getLifeCycleLock().writeLock().lock();
        try {
            if (!this.isRunning()) {
                return;
            }
            this.stopProcessing();
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            ((ConcurrentParallelGatewaySenderQueue)this.eventProcessor.getQueue()).cleanUp();
            logger.info("Stopped  {}", (Object)this);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, (Object)this);
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParallelGatewaySender{");
        sb.append("id=").append(this.getId());
        sb.append(",remoteDsId=").append(this.getRemoteDSId());
        sb.append(",isRunning =").append(this.isRunning());
        sb.append("}");
        return sb.toString();
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = true;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        for (GatewayEventFilter filter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(filter.getClass().getName());
        }
        for (GatewayEventFilter filter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(filter.getClass().getName());
        }
        for (AsyncEventListener listener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(listener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
    }

    public void setModifiedEventId(EntryEventImpl clonedEvent) {
        int bucketId = -1;
        bucketId = clonedEvent.getRegion() instanceof DistributedRegion ? PartitionedRegionHelper.getHashKey((Object)clonedEvent.getKey(), (int)this.getMaxParallelismForReplicatedRegion()) : PartitionedRegionHelper.getHashKey((EntryOperation)clonedEvent);
        EventID originalEventId = clonedEvent.getEventId();
        long originatingThreadId = ThreadIdentifier.getRealThreadID((long)originalEventId.getThreadID());
        long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket((int)bucketId, (long)originatingThreadId, (int)this.getEventIdIndex());
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID(), bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, bucketId={}, original event id={}, threadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)bucketId, (Object)originalEventId, (Object)originatingThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.cache.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }
}

