/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.AvailablePort;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.GatewayReceiverException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverImpl
implements GatewayReceiver {
    private static final Logger logger = LogService.getLogger();
    private String hostnameForSenders;
    private int startPort;
    private int endPort;
    private int port;
    private int timeBetPings;
    private int socketBufferSize;
    private boolean manualStart;
    private final List<GatewayTransportFilter> filters;
    private String bindAdd;
    private CacheServer receiver;
    private final InternalCache cache;

    public GatewayReceiverImpl(InternalCache cache, int startPort, int endPort, int timeBetPings, int buffSize, String bindAdd, List<GatewayTransportFilter> filters, String hostnameForSenders, boolean manualStart) {
        this.cache = cache;
        this.hostnameForSenders = hostnameForSenders;
        this.startPort = startPort;
        this.endPort = endPort;
        this.timeBetPings = timeBetPings;
        this.socketBufferSize = buffSize;
        this.bindAdd = bindAdd;
        this.filters = filters;
        this.manualStart = manualStart;
    }

    public String getHostnameForSenders() {
        return this.hostnameForSenders;
    }

    public String getHost() {
        if (this.receiver != null) {
            return ((CacheServerImpl)this.receiver).getExternalAddress();
        }
        if (this.hostnameForSenders != null && !this.hostnameForSenders.isEmpty()) {
            return this.hostnameForSenders;
        }
        if (this.bindAdd != null && !this.bindAdd.isEmpty()) {
            return this.bindAdd;
        }
        try {
            return SocketCreator.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not get host name", e);
        }
    }

    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.filters;
    }

    public int getMaximumTimeBetweenPings() {
        return this.timeBetPings;
    }

    public int getPort() {
        return this.port;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public boolean isManualStart() {
        return this.manualStart;
    }

    public CacheServer getServer() {
        return this.receiver;
    }

    private boolean tryToStart(int port) {
        if (!AvailablePort.isPortAvailable((int)port, (int)0, (InetAddress)AvailablePort.getAddress((int)0))) {
            return false;
        }
        this.receiver.setPort(port);
        this.receiver.setSocketBufferSize(this.socketBufferSize);
        this.receiver.setMaximumTimeBetweenPings(this.timeBetPings);
        if (this.hostnameForSenders != null && !this.hostnameForSenders.isEmpty()) {
            this.receiver.setHostnameForClients(this.hostnameForSenders);
        }
        this.receiver.setBindAddress(this.bindAdd);
        this.receiver.setGroups(new String[]{"__recv__group"});
        ((CacheServerImpl)this.receiver).setGatewayTransportFilter(this.filters);
        try {
            this.receiver.start();
            this.port = port;
            return true;
        }
        catch (IOException e) {
            logger.info("Failed to create server socket on  {}[{}]", (Object)this.bindAdd, (Object)port);
            return false;
        }
    }

    public void start() throws IOException {
        int loopStartPort;
        if (this.receiver == null) {
            this.receiver = this.cache.addCacheServer(true);
        }
        if (this.receiver.isRunning()) {
            logger.warn("Gateway Receiver is already running");
            return;
        }
        int port = loopStartPort = this.getPortToStart();
        while (!this.tryToStart(port)) {
            port = port == this.endPort && this.startPort != this.endPort ? this.startPort : ++port;
            if (port != loopStartPort && port <= this.endPort) continue;
            throw new GatewayReceiverException("No available free port found in the given range (" + this.startPort + "-" + this.endPort + ")");
        }
        logger.info("The GatewayReceiver started on port : {}", (Object)this.port);
        InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_START, (Object)this);
    }

    private int getPortToStart() {
        int rPort = this.startPort == this.endPort ? this.startPort : AvailablePort.getRandomAvailablePortInRange((int)this.startPort, (int)this.endPort, (int)0);
        return rPort;
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new GatewayReceiverException("Gateway Receiver is not running");
        }
        this.receiver.stop();
    }

    public void destroy() {
        logger.info("Destroying Gateway Receiver: " + this);
        if (this.receiver == null) {
            this.cache.removeGatewayReceiver((GatewayReceiver)this);
        } else {
            if (this.receiver.isRunning()) {
                throw new GatewayReceiverException("Gateway Receiver is running and needs to be stopped first");
            }
            this.cache.removeGatewayReceiver((GatewayReceiver)this);
            this.cache.removeCacheServer(this.receiver);
        }
        InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_DESTROY, (Object)this);
    }

    public String getBindAddress() {
        return this.bindAdd;
    }

    public boolean isRunning() {
        if (this.receiver != null) {
            return this.receiver.isRunning();
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("Gateway Receiver").append("@").append(Integer.toHexString(this.hashCode())).append("'; port=").append(this.getPort()).append("; bindAddress=").append(this.getBindAddress()).append("'; hostnameForSenders=").append(this.getHostnameForSenders()).append("; maximumTimeBetweenPings=").append(this.getMaximumTimeBetweenPings()).append("; socketBufferSize=").append(this.getSocketBufferSize()).append("; isManualStart=").append(this.isManualStart()).append("; group=").append(Arrays.toString(new String[]{"__recv__group"})).append("]").toString();
    }
}

