/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.net.ConnectException;
import java.util.StringTokenizer;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorResponse;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractRemoteGatewaySender
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();
    protected int proxyFailureTries = 0;

    public AbstractRemoteGatewaySender(InternalCache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    public synchronized void initProxy() {
        if (this.remoteDSId == -1 || this.proxy != null && !this.proxy.isDestroyed()) {
            return;
        }
        int locatorCount = 0;
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.setPRSingleHopEnabled(false);
        if (this.locatorDiscoveryCallback != null) {
            pf.setLocatorDiscoveryCallback(this.locatorDiscoveryCallback);
        }
        pf.setReadTimeout(this.socketReadTimeout);
        pf.setIdleTimeout((long)this.connectionIdleTimeOut);
        pf.setSocketBufferSize(this.socketBufferSize);
        pf.setServerGroup("__recv__group");
        RemoteLocatorRequest request = new RemoteLocatorRequest(this.remoteDSId, pf.getPoolAttributes().getServerGroup());
        String locators = this.cache.getInternalDistributedSystem().getConfig().getLocators();
        if (logger.isDebugEnabled()) {
            logger.debug("Gateway Sender is attempting to configure pool with remote locator information");
        }
        StringTokenizer locatorsOnThisVM = new StringTokenizer(locators, ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            String localLocator = locatorsOnThisVM.nextToken();
            DistributionLocatorId locatorID = new DistributionLocatorId(localLocator);
            try {
                RemoteLocatorResponse response = (RemoteLocatorResponse)new TcpClient().requestToServer(locatorID.getHost(), (Object)request, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                if (response == null) continue;
                if (response.getLocators() == null) {
                    if (!this.logProxyFailure()) continue;
                    logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.AbstractGatewaySender_REMOTE_LOCATOR_FOR_REMOTE_SITE_0_IS_NOT_AVAILABLE_IN_LOCAL_LOCATOR_1, (Object[])new Object[]{this.remoteDSId, localLocator}));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Received the remote site {} location information:", (Object)this.remoteDSId, response.getLocators());
                }
                for (String remoteLocator : response.getLocators()) {
                    try {
                        DistributionLocatorId locatorId = new DistributionLocatorId(remoteLocator);
                        pf.addLocator(locatorId.getHost().getHostName(), locatorId.getPort());
                        ++locatorCount;
                    }
                    catch (Exception e) {
                        if (!this.logProxyFailure()) continue;
                        logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.PoolFactoryImpl_CAUGHT_EXCEPTION_ATTEMPTING_TO_ADD_REMOTE_LOCATOR_0, (Object[])new Object[]{remoteLocator}), (Throwable)e);
                    }
                }
                break;
            }
            catch (IOException ioe2) {
                Throwable ioe2;
                if (!this.logProxyFailure()) continue;
                String ioeStr = "";
                if (!logger.isDebugEnabled() && ioe2 instanceof ConnectException) {
                    ioeStr = ": " + ioe2.toString();
                    ioe2 = null;
                }
                logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.AbstractGatewaySender_SENDER_0_IS_NOT_ABLE_TO_CONNECT_TO_LOCAL_LOCATOR_1, (Object[])new Object[]{this.id, localLocator + ioeStr}), ioe2);
            }
            catch (ClassNotFoundException e) {
                if (!this.logProxyFailure()) continue;
                logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.AbstractGatewaySender_SENDER_0_IS_NOT_ABLE_TO_CONNECT_TO_LOCAL_LOCATOR_1, (Object[])new Object[]{this.id, localLocator}), (Throwable)e);
            }
        }
        if (locatorCount == 0) {
            if (this.logProxyFailure()) {
                logger.fatal((Message)LocalizedMessage.create((StringId)LocalizedStrings.AbstractGatewaySender_SENDER_0_COULD_NOT_GET_REMOTE_LOCATOR_INFORMATION_FOR_SITE_1, (Object[])new Object[]{this.id, this.remoteDSId}));
            }
            ++this.proxyFailureTries;
            throw new GatewaySenderConfigurationException(LocalizedStrings.AbstractGatewaySender_SENDER_0_COULD_NOT_GET_REMOTE_LOCATOR_INFORMATION_FOR_SITE_1.toLocalizedString(new Object[]{this.id, this.remoteDSId}));
        }
        pf.init((GatewaySender)this);
        this.proxy = (PoolImpl)pf.create(this.getId());
        if (this.proxyFailureTries > 0) {
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.AbstractGatewaySender_SENDER_0_GOT_REMOTE_LOCATOR_INFORMATION_FOR_SITE_1, (Object[])new Object[]{this.id, this.remoteDSId, this.proxyFailureTries}));
            this.proxyFailureTries = 0;
        }
    }

    protected boolean logProxyFailure() {
        assert (Thread.holdsLock((Object)this));
        if (logger.isDebugEnabled() || this.proxyFailureTries == 0) {
            return true;
        }
        if (this.proxyFailureTries >= 3000) {
            return this.proxyFailureTries % 3000 == 0;
        }
        return this.proxyFailureTries == 30 || this.proxyFailureTries == 300;
    }
}

