/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.io.InvalidClassException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class ObjectInputFilterInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LogService.getLogger();
    private final Method ObjectInputFilter_checkInput;
    private final Method ObjectInputFilter_FilterInfo_serialClass;
    private final Object ObjectInputFilter_Status_ALLOWED;
    private final Object ObjectInputFilter_Status_REJECTED;
    private final Object objectInputFilter;
    private final Collection<String> sanctionedClasses;

    ObjectInputFilterInvocationHandler(Method ObjectInputFilter_checkInput, Method ObjectInputFilter_FilterInfo_serialClass, Object ObjectInputFilter_Status_ALLOWED, Object ObjectInputFilter_Status_REJECTED, Object objectInputFilter, Collection<String> sanctionedClasses) {
        this.ObjectInputFilter_checkInput = ObjectInputFilter_checkInput;
        this.ObjectInputFilter_FilterInfo_serialClass = ObjectInputFilter_FilterInfo_serialClass;
        this.ObjectInputFilter_Status_ALLOWED = ObjectInputFilter_Status_ALLOWED;
        this.ObjectInputFilter_Status_REJECTED = ObjectInputFilter_Status_REJECTED;
        this.objectInputFilter = objectInputFilter;
        this.sanctionedClasses = Collections.unmodifiableCollection(sanctionedClasses);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!"checkInput".equals(method.getName())) {
            return method.invoke(this.objectInputFilter, args);
        }
        Objects.requireNonNull(args, "Single argument FilterInfo is null");
        if (args.length != 1) {
            throw new IllegalArgumentException("Single argument FilterInfo is required");
        }
        Object objectInputFilter_filterInfo = args[0];
        Class serialClass = (Class)this.ObjectInputFilter_FilterInfo_serialClass.invoke(objectInputFilter_filterInfo, new Object[0]);
        if (serialClass == null) {
            return this.ObjectInputFilter_checkInput.invoke(this.objectInputFilter, objectInputFilter_filterInfo);
        }
        String serialClassName = serialClass.getName();
        if (serialClass.isArray()) {
            serialClassName = serialClass.getComponentType().getName();
        }
        if (this.sanctionedClasses.contains(serialClassName)) {
            return this.ObjectInputFilter_Status_ALLOWED;
        }
        Object objectInputFilter_Status = this.ObjectInputFilter_checkInput.invoke(this.objectInputFilter, objectInputFilter_filterInfo);
        if (objectInputFilter_Status == this.ObjectInputFilter_Status_REJECTED) {
            logger.fatal("Serialization filter is rejecting class {}", (Object)serialClassName, (Object)new InvalidClassException(serialClassName));
        }
        return objectInputFilter_Status;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + '{' + "objectInputFilter=" + this.objectInputFilter + ", sanctionedClassesCount=" + this.sanctionedClasses.size() + '}';
    }
}

