/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="SystemAlerts")
@Scope(value="singleton")
public class SystemAlertsService
implements PulseService {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = mapper.createObjectNode();
        JsonNode requestDataJSON = mapper.readTree(request.getParameter("pulseData"));
        int pageNumber = 1;
        String strPageNumber = requestDataJSON.get("SystemAlerts").get("pageNumber").textValue();
        if (StringUtils.isNotBlank((CharSequence)strPageNumber)) {
            try {
                pageNumber = Integer.valueOf(strPageNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        responseJSON.put("systemAlerts", (JsonNode)SystemAlertsService.getAlertsJson(cluster, pageNumber));
        responseJSON.put("pageNumber", cluster.getNotificationPageNumber());
        responseJSON.put("connectedFlag", cluster.isConnectedFlag());
        responseJSON.put("connectedErrorMsg", cluster.getConnectionErrorMsg());
        return responseJSON;
    }

    public static ObjectNode getAlertsJson(Cluster cluster, int pageNumber) {
        Cluster.Alert[] alertsList = cluster.getAlertsList();
        ObjectNode alertsJsonObject = mapper.createObjectNode();
        if (alertsList != null && alertsList.length > 0) {
            ArrayNode errorJsonArray = mapper.createArrayNode();
            ArrayNode severeJsonArray = mapper.createArrayNode();
            ArrayNode warningJsonArray = mapper.createArrayNode();
            ArrayNode infoJsonArray = mapper.createArrayNode();
            cluster.setNotificationPageNumber(pageNumber);
            for (Cluster.Alert alert : alertsList) {
                ObjectNode objAlertJson = mapper.createObjectNode();
                objAlertJson.put("description", alert.getDescription());
                objAlertJson.put("memberName", alert.getMemberName());
                objAlertJson.put("severity", alert.getSeverity());
                objAlertJson.put("isAcknowledged", alert.isAcknowledged());
                objAlertJson.put("timestamp", alert.getTimestamp().toString());
                objAlertJson.put("iso8601Ts", alert.getIso8601Ts());
                objAlertJson.put("id", alert.getId());
                if (alert.getSeverity() == 0) {
                    severeJsonArray.add((JsonNode)objAlertJson);
                    continue;
                }
                if (alert.getSeverity() == 1) {
                    errorJsonArray.add((JsonNode)objAlertJson);
                    continue;
                }
                if (alert.getSeverity() == 2) {
                    warningJsonArray.add((JsonNode)objAlertJson);
                    continue;
                }
                infoJsonArray.add((JsonNode)objAlertJson);
            }
            alertsJsonObject.put("info", (JsonNode)infoJsonArray);
            alertsJsonObject.put("warnings", (JsonNode)warningJsonArray);
            alertsJsonObject.put("errors", (JsonNode)errorJsonArray);
            alertsJsonObject.put("severe", (JsonNode)severeJsonArray);
        }
        return alertsJsonObject;
    }
}

