/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterJVMPauses")
@Scope(value="singleton")
public class ClusterGCPausesService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        ArrayNode pauses = this.mapper.createArrayNode();
        for (Object obj : cluster.getStatisticTrend(7)) {
            if (!(obj instanceof Number)) continue;
            pauses.add(((Number)obj).longValue());
        }
        responseJSON.put("currentGCPauses", cluster.getGarbageCollectionCount());
        responseJSON.put("gCPausesTrend", (JsonNode)pauses);
        return responseJSON;
    }
}

