/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class IPAddressUtil {
    private static Pattern VALID_IPV4_PATTERN = null;
    private static Pattern VALID_IPV6_PATTERN = null;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";

    public static Boolean isIPv4LiteralAddress(String IPAddress) {
        Matcher matcher = VALID_IPV4_PATTERN.matcher(IPAddress);
        return matcher.matches();
    }

    public static Boolean isIPv6LiteralAddress(String IPAddress) {
        Matcher matcher = VALID_IPV6_PATTERN.matcher(IPAddress);
        return matcher.matches();
    }

    static {
        try {
            VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
            VALID_IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

