/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geode.modules.session.catalina.DeltaSessionFacade;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class AbstractCommitSessionValve<SelfT extends AbstractCommitSessionValve<?>>
extends ValveBase {
    private static final Log log = LogFactory.getLog(AbstractCommitSessionValve.class);
    protected static final String info = "org.apache.geode.modules.session.catalina.CommitSessionValve/1.0";

    AbstractCommitSessionValve() {
        log.info((Object)"Initialized");
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.getNext().invoke(request, this.wrapResponse(response));
        }
        finally {
            AbstractCommitSessionValve.commitSession(request);
        }
    }

    protected static <SelfT extends AbstractCommitSessionValve<?>> void commitSession(Request request) {
        DeltaSessionFacade session;
        Context context = request.getContext();
        Manager manager = context.getManager();
        if (manager instanceof DeltaSessionManager && (session = (DeltaSessionFacade)request.getSession(false)) != null) {
            DeltaSessionManager deltaSessionManager = (DeltaSessionManager)UncheckedUtils.uncheckedCast((Object)manager);
            if (session.isValid()) {
                deltaSessionManager.removeTouchedSession(session.getId());
                session.commit();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf((Object)session) + ": Committed."));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(String.valueOf((Object)session) + ": Not valid so not committing."));
            }
        }
    }

    abstract Response wrapResponse(Response var1);
}

