/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SerializedCacheValue;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.modules.gatewaydelta.GatewayDelta;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaCreateEvent;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaDestroyEvent;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEvent;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEventApplicationCacheListener;

public class GatewayDeltaForwarderCacheListener
extends CacheListenerAdapter<String, GatewayDelta>
implements Declarable {
    private final Cache cache;
    private Region<String, GatewayDeltaEvent> gatewayDeltaRegion;

    public GatewayDeltaForwarderCacheListener() {
        this(CacheFactory.getAnyInstance());
    }

    public GatewayDeltaForwarderCacheListener(Cache cache) {
        this.cache = cache;
    }

    public void afterCreate(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() == null) {
            if (this.cache.getLogger().fineEnabled()) {
                String builder = "GatewayDeltaForwarderCacheListener: Received create event for " + (String)event.getKey() + "->" + String.valueOf(event.getNewValue()) + " that originated in the local site. Sending it to the remote site.";
                this.cache.getLogger().fine(builder);
            }
            String regionName = event.getRegion().getFullPath();
            String sessionId = (String)event.getKey();
            SerializedCacheValue scv = event.getSerializedNewValue();
            if (scv == null) {
                this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaCreateEvent(regionName, sessionId, EntryEventImpl.serialize((Object)event.getNewValue())));
            } else {
                this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaCreateEvent(regionName, sessionId, scv.getSerializedValue()));
            }
        } else if (this.cache.getLogger().fineEnabled()) {
            String builder = "GatewayDeltaForwarderCacheListener: Received create event for " + (String)event.getKey() + "->" + String.valueOf(event.getNewValue()) + " that originated in the remote site.";
            this.cache.getLogger().fine(builder);
        }
    }

    public void afterUpdate(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() == null) {
            if (this.cache.getLogger().fineEnabled()) {
                String builder = "GatewayDeltaForwarderCacheListener: Received update event for " + (String)event.getKey() + "->" + String.valueOf(event.getNewValue()) + " that originated in the local site. Sending it to the remote site.";
                this.cache.getLogger().fine(builder);
            }
            GatewayDelta session = (GatewayDelta)event.getNewValue();
            this.getGatewayDeltaRegion().put((Object)((String)event.getKey()), (Object)session.getCurrentGatewayDeltaEvent());
            session.setCurrentGatewayDeltaEvent(null);
        } else if (this.cache.getLogger().fineEnabled()) {
            String builder = "GatewayDeltaForwarderCacheListener: Received update event for " + (String)event.getKey() + "->" + String.valueOf(event.getNewValue()) + " that originated in the remote site.";
            this.cache.getLogger().fine(builder);
        }
    }

    public void afterDestroy(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() != null) {
            if (this.cache.getLogger().fineEnabled()) {
                String builder = "GatewayDeltaForwarderCacheListener: Received destroy event for " + (String)event.getKey() + "->" + String.valueOf(event.getNewValue()) + " that originated in the local site. Sending it to the remote site.";
                this.cache.getLogger().fine(builder);
            }
            String sessionId = (String)event.getKey();
            this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaDestroyEvent(event.getRegion().getFullPath(), sessionId));
        } else if (this.cache.getLogger().fineEnabled()) {
            String builder = "GatewayDeltaForwarderCacheListener: Received destroy event for session " + (String)event.getKey() + " that either expired or originated in the remote site.";
            this.cache.getLogger().fine(builder);
        }
    }

    private Region<String, GatewayDeltaEvent> getGatewayDeltaRegion() {
        if (this.gatewayDeltaRegion == null) {
            this.gatewayDeltaRegion = this.createOrRetrieveGatewayDeltaRegion();
        }
        return this.gatewayDeltaRegion;
    }

    private Region<String, GatewayDeltaEvent> createOrRetrieveGatewayDeltaRegion() {
        Region region = this.cache.getRegion("__gatewayDelta");
        if (region == null) {
            region = this.cache.createRegionFactory().setScope(Scope.LOCAL).setDataPolicy(DataPolicy.EMPTY).setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL)).addCacheListener((CacheListener)new GatewayDeltaEventApplicationCacheListener()).create("__gatewayDelta");
        }
        if (this.cache.getLogger().fineEnabled()) {
            String builder = "GatewayDeltaForwarderCacheListener: Created gateway delta region: " + String.valueOf(region);
            this.cache.getLogger().fine(builder);
        }
        return region;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof GatewayDeltaForwarderCacheListener;
    }

    public int hashCode() {
        return GatewayDeltaForwarderCacheListener.class.hashCode();
    }
}

