/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;

public class SerializablePrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String password;
    private final List<String> roles;

    private SerializablePrincipal(String name, String password, List<String> roles) {
        this.name = name;
        this.password = password;
        this.roles = roles;
    }

    public static SerializablePrincipal createPrincipal(GenericPrincipal principal) {
        if (principal == null) {
            return null;
        }
        return new SerializablePrincipal(principal.getName(), null, Arrays.asList(principal.getRoles()));
    }

    public Principal getPrincipal(Realm realm) {
        return new GenericPrincipal(this.name, this.password, this.roles);
    }

    public String toString() {
        return "SerializablePrincipal[name=" + this.name + ", roles=" + String.valueOf(this.roles) + "]";
    }
}

