/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;

public class JvmRouteBinderValve
extends ValveBase {
    public void invoke(Request request, Response response) throws IOException, ServletException {
        DeltaSessionManager absMgr;
        String localJvmRoute;
        Manager manager = request.getContext().getManager();
        if (manager instanceof DeltaSessionManager && (localJvmRoute = (absMgr = (DeltaSessionManager)manager).getJvmRoute()) != null) {
            this.handlePossibleFailover(request, absMgr, localJvmRoute);
        }
        this.getNext().invoke(request, response);
    }

    private void handlePossibleFailover(Request request, DeltaSessionManager manager, String localJvmRoute) {
        String sessionId = request.getRequestedSessionId();
        if (sessionId != null) {
            String requestJvmRoute = null;
            int index = sessionId.indexOf(".");
            if (index > 0) {
                requestJvmRoute = sessionId.substring(index + 1);
            }
            if (requestJvmRoute != null && !requestJvmRoute.equals(localJvmRoute)) {
                Session session;
                if (manager.getLogger().isDebugEnabled()) {
                    String builder = (Object)((Object)this) + ": Handling failover of session " + sessionId + " from " + requestJvmRoute + " to " + localJvmRoute;
                    manager.getLogger().debug((Object)builder);
                }
                if ((session = manager.findSession(sessionId)) == null) {
                    String builder = (Object)((Object)this) + ": Did not find session " + sessionId + " to failover in " + manager;
                    manager.getLogger().warn((Object)builder);
                } else {
                    String baseSessionId = sessionId.substring(0, index);
                    String newSessionId = baseSessionId + "." + localJvmRoute;
                    session.setId(newSessionId);
                    request.changeSessionId(newSessionId);
                }
            }
        }
    }
}

