/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.modules.gatewaydelta.AbstractGatewayDeltaEvent;

public class GatewayDeltaDestroyEvent
extends AbstractGatewayDeltaEvent {
    GatewayDeltaDestroyEvent(String regionName, String key) {
        super(regionName, key);
    }

    @Override
    public void apply(Cache cache) {
        Region region = this.getRegion(cache);
        try {
            region.destroy((Object)this.key);
            if (cache.getLogger().fineEnabled()) {
                cache.getLogger().fine("Applied " + this);
            }
        }
        catch (EntryNotFoundException e) {
            cache.getLogger().warning(this + ": Session " + this.key + " was not found");
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    public String toString() {
        return "GatewayDeltaDestroyEvent[regionName=" + this.regionName + "; key=" + this.key + "]";
    }
}

