/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.modules.session.catalina.DeltaSessionInterface;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEvent;

public class DeltaSessionUpdateAttributeEvent
implements DeltaSessionAttributeEvent {
    private String attributeName;
    private Object attributeValue;

    public DeltaSessionUpdateAttributeEvent() {
    }

    public DeltaSessionUpdateAttributeEvent(String attributeName, Object attributeValue) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Object getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public void apply(DeltaSessionInterface session) {
        session.localUpdateAttribute(this.attributeName, this.attributeValue);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.attributeName = DataSerializer.readString((DataInput)in);
        this.attributeValue = DataSerializer.readObject((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.attributeName, (DataOutput)out);
        DataSerializer.writeObject((Object)this.attributeValue, (DataOutput)out);
    }

    public static void registerInstantiator(int id) {
        Instantiator.register((Instantiator)new Instantiator(DeltaSessionUpdateAttributeEvent.class, id){

            public DataSerializable newInstance() {
                return new DeltaSessionUpdateAttributeEvent();
            }
        });
    }

    public String toString() {
        return "DeltaSessionUpdateAttributeEvent[" + "attributeName=" + this.attributeName + "; attributeValue=" + this.attributeValue + "]";
    }
}

