/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.modules.gatewaydelta.GatewayDeltaForwarderCacheListener;
import com.gemstone.gemfire.modules.session.catalina.callback.SessionExpirationCacheListener;
import com.gemstone.gemfire.modules.util.DebugCacheListener;
import com.gemstone.gemfire.modules.util.RegionConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;

public class RegionHelper {
    public static final String NAME = "gemfire_modules";

    public static Region createRegion(Cache cache, RegionConfiguration configuration) {
        RegionAttributes requestedRegionAttributes = RegionHelper.getRegionAttributes(cache, configuration);
        Region region = cache.createRegion(configuration.getRegionName(), requestedRegionAttributes);
        if (configuration.getEnableDebugListener()) {
            cache.getLogger().info("Created new session region: " + region);
            cache.getLogger().info(RegionHelper.generateCacheXml(cache));
        }
        return region;
    }

    public static void validateRegion(Cache cache, RegionConfiguration configuration, Region region) {
        RegionAttributes existingAttributes = region.getAttributes();
        RegionAttributesCreation existingRACreation = new RegionAttributesCreation(existingAttributes, false);
        RegionAttributes requestedRegionAttributes = RegionHelper.getRegionAttributes(cache, configuration);
        existingRACreation.sameAs(requestedRegionAttributes);
    }

    public static RebalanceResults rebalanceRegion(Region region) throws CancellationException, InterruptedException {
        String regionName = region.getName();
        if (!PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Region ").append(regionName).append(" is not partitioned. Instead, it is ").append(region.getAttributes().getDataPolicy()).append(". It can't be rebalanced.");
            throw new IllegalArgumentException(builder.toString());
        }
        ResourceManager resourceManager = region.getCache().getResourceManager();
        RebalanceFactory rebalanceFactory = resourceManager.createRebalanceFactory();
        HashSet<String> regionsToRebalance = new HashSet<String>();
        regionsToRebalance.add(regionName);
        rebalanceFactory.includeRegions(regionsToRebalance);
        RebalanceOperation rebalanceOperation = rebalanceFactory.start();
        return rebalanceOperation.getResults();
    }

    public static RebalanceResults rebalanceCache(GemFireCache cache) throws CancellationException, InterruptedException {
        ResourceManager resourceManager = cache.getResourceManager();
        RebalanceFactory rebalanceFactory = resourceManager.createRebalanceFactory();
        RebalanceOperation rebalanceOperation = rebalanceFactory.start();
        return rebalanceOperation.getResults();
    }

    public static String generateCacheXml(Cache cache) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
            pw.close();
            return sw.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static RegionAttributes getRegionAttributes(Cache cache, RegionConfiguration configuration) {
        RegionAttributes baseRequestedAttributes = cache.getRegionAttributes(configuration.getRegionAttributesId());
        if (baseRequestedAttributes == null) {
            throw new IllegalArgumentException("No region attributes named " + configuration.getRegionAttributesId() + " are defined.");
        }
        AttributesFactory requestedFactory = new AttributesFactory(baseRequestedAttributes);
        int maxInactiveInterval = configuration.getMaxInactiveInterval();
        if (maxInactiveInterval != -1) {
            requestedFactory.setStatisticsEnabled(true);
            if (configuration.getCustomExpiry() == null) {
                requestedFactory.setEntryIdleTimeout(new ExpirationAttributes(maxInactiveInterval, ExpirationAction.DESTROY));
            } else {
                requestedFactory.setCustomEntryIdleTimeout(configuration.getCustomExpiry());
            }
        }
        if (configuration.getEnableGatewayDeltaReplication()) {
            requestedFactory.addCacheListener((CacheListener)new GatewayDeltaForwarderCacheListener(cache));
        }
        if (configuration.getEnableDebugListener()) {
            requestedFactory.addCacheListener((CacheListener)new DebugCacheListener());
        }
        if (configuration.getSessionExpirationCacheListener()) {
            requestedFactory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
        }
        if (configuration.getCacheWriterName() != null) {
            try {
                CacheWriter writer = (CacheWriter)Class.forName(configuration.getCacheWriterName()).newInstance();
                requestedFactory.setCacheWriter(writer);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not set a cacheWriter for the region", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not set a cacheWriter for the region", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not set a cacheWriter for the region", e);
            }
        }
        return requestedFactory.create();
    }

    private RegionHelper() {
    }

    public static String getRebalanceResultsMessage(RebalanceResults results) {
        StringBuilder builder = new StringBuilder();
        for (PartitionRebalanceInfo rebalanceInfo : results.getPartitionRebalanceDetails()) {
            RegionHelper.fillInRebalanceResultsSummary(builder, rebalanceInfo);
            RegionHelper.fillInRebalanceResultsMemberDetails(builder, rebalanceInfo.getPartitionMemberDetailsBefore(), "Before");
            RegionHelper.fillInRebalanceResultsMemberDetails(builder, rebalanceInfo.getPartitionMemberDetailsAfter(), "After");
        }
        return builder.toString();
    }

    private static void fillInRebalanceResultsSummary(StringBuilder builder, PartitionRebalanceInfo rebalanceInfo) {
        builder.append("\nRebalanced region ").append(rebalanceInfo.getRegionPath()).append(" in ").append(rebalanceInfo.getTime()).append(" ms").append("\nCreated ").append(rebalanceInfo.getBucketCreatesCompleted()).append(" buckets containing ").append(rebalanceInfo.getBucketCreateBytes()).append(" bytes in ").append(rebalanceInfo.getBucketCreateTime()).append(" ms").append("\nTransferred ").append(rebalanceInfo.getBucketTransfersCompleted()).append(" buckets containing ").append(rebalanceInfo.getBucketTransferBytes()).append(" bytes in ").append(rebalanceInfo.getBucketTransferTime()).append(" ms").append("\nTransferred ").append(rebalanceInfo.getPrimaryTransfersCompleted()).append(" primary buckets in ").append(rebalanceInfo.getPrimaryTransferTime()).append(" ms");
    }

    private static void fillInRebalanceResultsMemberDetails(StringBuilder builder, Set<PartitionMemberInfo> memberInfoSet, String when) {
        builder.append("\nMember Info ").append(when).append(" Rebalance:\n");
        for (PartitionMemberInfo info : memberInfoSet) {
            builder.append("\tdistributedMember=").append(info.getDistributedMember()).append(", configuredMaxMemory=").append(info.getConfiguredMaxMemory()).append(", size=").append(info.getSize()).append(", bucketCount=").append(info.getBucketCount()).append(", primaryCount=").append(info.getPrimaryCount());
        }
    }
}

