/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.modules.util.CreateRegionFunction;
import com.gemstone.gemfire.modules.util.RegionSizeFunction;
import com.gemstone.gemfire.modules.util.TouchPartitionedRegionEntriesFunction;
import com.gemstone.gemfire.modules.util.TouchReplicatedRegionEntriesFunction;
import java.util.List;
import java.util.Set;

public class BootstrappingFunction
implements Function,
MembershipListener {
    private static final long serialVersionUID = 1856043174458190605L;
    public static final String ID = "bootstrapping-function";
    private static final int TIME_TO_WAIT_FOR_CACHE = Integer.getInteger("gemfiremodules.timeToWaitForCache", 30000);

    public void execute(FunctionContext context) {
        Cache cache = this.verifyCacheExists();
        this.registerAsMembershipListener(cache);
        this.registerFunctions();
        context.getResultSender().lastResult((Object)Boolean.TRUE);
    }

    private Cache verifyCacheExists() {
        Cache cache = null;
        for (int timeToWait = 0; timeToWait < TIME_TO_WAIT_FOR_CACHE; timeToWait += 250) {
            try {
                cache = CacheFactory.getAnyInstance();
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        if (cache == null) {
            cache = new CacheFactory().create();
        }
        return cache;
    }

    private void registerAsMembershipListener(Cache cache) {
        DM dm = ((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager();
        dm.addMembershipListener((MembershipListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFunctions() {
        String string = ID;
        synchronized (ID) {
            if (!FunctionService.isRegistered((String)"create-region-function")) {
                FunctionService.registerFunction((Function)new CreateRegionFunction());
            }
            if (!FunctionService.isRegistered((String)"touch-partitioned-region-entries")) {
                FunctionService.registerFunction((Function)new TouchPartitionedRegionEntriesFunction());
            }
            if (!FunctionService.isRegistered((String)"touch-replicated-region-entries")) {
                FunctionService.registerFunction((Function)new TouchReplicatedRegionEntriesFunction());
            }
            if (!FunctionService.isRegistered((String)"region-size-function")) {
                FunctionService.registerFunction((Function)new RegionSizeFunction());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void bootstrapMember(InternalDistributedMember member) {
        Cache cache = CacheFactory.getAnyInstance();
        Execution execution = FunctionService.onMember((DistributedSystem)cache.getDistributedSystem(), (DistributedMember)member);
        ResultCollector collector = execution.execute((Function)this);
        try {
            collector.getResult();
        }
        catch (Exception e) {
            cache.getLogger().warning("Caught unexpected exception:", (Throwable)e);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof BootstrappingFunction;
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
    }

    public void memberJoined(InternalDistributedMember id) {
        this.bootstrapMember(id);
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    public void quorumLost(Set<InternalDistributedMember> internalDistributedMembers, List<InternalDistributedMember> internalDistributedMembers2) {
    }
}

