/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import java.util.Properties;
import java.util.Set;

public class TouchPartitionedRegionEntriesFunction
implements Function,
Declarable {
    private static final long serialVersionUID = -3700389655056961153L;
    private final Cache cache;
    public static final String ID = "touch-partitioned-region-entries";

    public TouchPartitionedRegionEntriesFunction() {
        this(CacheFactory.getAnyInstance());
    }

    public TouchPartitionedRegionEntriesFunction(Cache cache) {
        this.cache = cache;
    }

    public void execute(FunctionContext context) {
        RegionFunctionContext rfc = (RegionFunctionContext)context;
        Set keys = rfc.getFilter();
        Region primaryDataSet = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfc);
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Function ").append(ID).append(" received request to touch ").append(primaryDataSet.getFullPath()).append("->").append(keys);
            this.cache.getLogger().fine(builder.toString());
        }
        for (String key : keys) {
            primaryDataSet.get((Object)key);
        }
        context.getResultSender().lastResult((Object)true);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean hasResult() {
        return true;
    }

    public void init(Properties properties) {
    }
}

