/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.locks.DistributedMemberLock;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.modules.util.RegionConfiguration;
import com.gemstone.gemfire.modules.util.RegionConfigurationCacheListener;
import com.gemstone.gemfire.modules.util.RegionHelper;
import com.gemstone.gemfire.modules.util.RegionStatus;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Properties;

public class CreateRegionFunction
implements Function,
Declarable {
    private static final long serialVersionUID = -9210226844302128969L;
    private final Cache cache;
    private final Region<String, RegionConfiguration> regionConfigurationsRegion;
    public static final String ID = "create-region-function";
    private static final boolean DUMP_SESSION_CACHE_XML = Boolean.getBoolean("gemfiremodules.dumpSessionCacheXml");
    private static final String REGION_CONFIGURATION_METADATA_REGION = "__regionConfigurationMetadata";

    public CreateRegionFunction() {
        this(CacheFactory.getAnyInstance());
    }

    public CreateRegionFunction(Cache cache) {
        this.cache = cache;
        this.regionConfigurationsRegion = this.createRegionConfigurationMetadataRegion();
    }

    public CreateRegionFunction(ClientCache cache) {
        this.cache = null;
        this.regionConfigurationsRegion = null;
    }

    public void execute(FunctionContext context) {
        RegionConfiguration configuration = (RegionConfiguration)context.getArguments();
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Function ").append(ID).append(" received request: ").append(configuration);
            this.cache.getLogger().fine(builder.toString());
        }
        RegionStatus status = this.createOrRetrieveRegion(configuration);
        if (DUMP_SESSION_CACHE_XML) {
            this.writeCacheXml();
        }
        context.getResultSender().lastResult((Object)status);
    }

    private RegionStatus createOrRetrieveRegion(RegionConfiguration configuration) {
        Region region;
        RegionStatus status = null;
        String regionName = configuration.getRegionName();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("Function create-region-function retrieving region named: " + regionName);
        }
        if ((region = this.cache.getRegion(regionName)) == null) {
            status = this.createRegion(configuration);
        } else {
            status = RegionStatus.VALID;
            try {
                RegionHelper.validateRegion(this.cache, configuration, region);
            }
            catch (Exception e) {
                if (!e.getMessage().equals(LocalizedStrings.RegionAttributesCreation_CACHELISTENERS_ARE_NOT_THE_SAME.toLocalizedString())) {
                    this.cache.getLogger().warning((Throwable)e);
                }
                status = RegionStatus.INVALID;
            }
        }
        return status;
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return true;
    }

    public boolean hasResult() {
        return true;
    }

    public void init(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionStatus createRegion(RegionConfiguration configuration) {
        DistributedMemberLock dml = this.getDistributedLock();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine(this + ": Attempting to lock " + dml);
        }
        long start = 0L;
        long end = 0L;
        RegionStatus status = null;
        try {
            String regionName;
            Region region;
            if (this.cache.getLogger().fineEnabled()) {
                start = System.currentTimeMillis();
            }
            dml.lockInterruptibly();
            if (this.cache.getLogger().fineEnabled()) {
                end = System.currentTimeMillis();
                this.cache.getLogger().fine(this + ": Obtained lock on " + dml + " in " + (end - start) + " ms");
            }
            if ((region = this.cache.getRegion(regionName = configuration.getRegionName())) == null) {
                this.regionConfigurationsRegion.put((Object)regionName, (Object)configuration);
                region = this.cache.getRegion(regionName);
                if (region == null) {
                    status = RegionStatus.INVALID;
                } else {
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr = (PartitionedRegion)region;
                        this.createBuckets(pr);
                    }
                    status = RegionStatus.VALID;
                }
            } else {
                status = RegionStatus.VALID;
                try {
                    RegionHelper.validateRegion(this.cache, configuration, region);
                }
                catch (Exception e) {
                    if (!e.getMessage().equals(LocalizedStrings.RegionAttributesCreation_CACHELISTENERS_ARE_NOT_THE_SAME.toLocalizedString())) {
                        this.cache.getLogger().warning((Throwable)e);
                    }
                    status = RegionStatus.INVALID;
                }
            }
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            builder.append(this).append(": Caught Exception attempting to create region named ").append(configuration.getRegionName()).append(":");
            this.cache.getLogger().warning(builder.toString(), (Throwable)e);
            status = RegionStatus.INVALID;
        }
        finally {
            try {
                dml.unlock();
            }
            catch (Exception exception) {}
        }
        return status;
    }

    private void createBuckets(PartitionedRegion region) {
        PartitionRegionHelper.assignBucketsToPartitions((Region)region);
    }

    private Region<String, RegionConfiguration> createRegionConfigurationMetadataRegion() {
        Region r = this.cache.getRegion(REGION_CONFIGURATION_METADATA_REGION);
        if (r != null) {
            return r;
        }
        RegionFactory factory = this.cache.createRegionFactory(RegionShortcut.REPLICATE);
        factory.addCacheListener((CacheListener)new RegionConfigurationCacheListener());
        return factory.create(REGION_CONFIGURATION_METADATA_REGION);
    }

    private void writeCacheXml() {
        File file = new File("cache-" + System.currentTimeMillis() + ".xml");
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)this.cache, (PrintWriter)pw);
            pw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DistributedMemberLock getDistributedLock() {
        String dlsName = this.regionConfigurationsRegion.getName();
        DistributedLockService lockService = this.initializeDistributedLockService(dlsName);
        String lockToken = dlsName + "_token";
        return new DistributedMemberLock(lockService, (Serializable)((Object)lockToken));
    }

    private DistributedLockService initializeDistributedLockService(String dlsName) {
        DistributedLockService lockService = DistributedLockService.getServiceNamed((String)dlsName);
        if (lockService == null) {
            lockService = DistributedLockService.create((String)dlsName, (DistributedSystem)this.cache.getDistributedSystem());
        }
        return lockService;
    }
}

