/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Links
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String HREF_PREFIX = "#HREF";
    public static final String URI_CONTEXT = "/management";
    public static final String URI_VERSION = "/v1";
    private String self;
    private String list;
    private final Map<String, String> links = new HashMap<String, String>();

    public Links() {
    }

    public Links(String id, String listUri) {
        this.setList(listUri);
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)listUri)) {
            this.setSelf(this.list + "/" + id);
        }
    }

    @JsonIgnore
    public String getSelf() {
        return this.self;
    }

    @JsonIgnore
    public void setSelf(String self) {
        this.self = self;
        this.addLink("self", self);
    }

    @JsonIgnore
    public String getList() {
        return this.list;
    }

    @JsonIgnore
    public void setList(String list) {
        this.list = list;
        this.addLink("list", list);
    }

    public void addLink(String key, String url) {
        this.links.put(key, Links.qualifyUrl(url));
    }

    @JsonAnySetter
    public void anySetter(String key, String url) {
    }

    @JsonAnyGetter
    public Map<String, String> getLinks() {
        return this.links;
    }

    private static String qualifyUrl(String uri) {
        if (uri.startsWith(URI_VERSION)) {
            return "#HREF/management" + uri;
        }
        if (uri.startsWith(URI_CONTEXT)) {
            return HREF_PREFIX + uri;
        }
        if (uri.startsWith(HREF_PREFIX)) {
            return uri;
        }
        return "#HREF/management/v1" + uri;
    }
}

