/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.client;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.internal.ClusterManagementServiceFactory;
import org.springframework.http.client.ClientHttpRequestFactory;

@Experimental
public class ClusterManagementServiceProvider {
    public static final String JAVA_CLIENT_CONTEXT = "java-client";
    public static final String GEODE_CONTEXT = "geode";
    private static Map<String, ClusterManagementServiceFactory> serviceFactories = null;

    public static ClusterManagementService getService() {
        return ClusterManagementServiceProvider.getServiceFactory(GEODE_CONTEXT).create();
    }

    public static ClusterManagementService getService(String username, String password) {
        return ClusterManagementServiceProvider.getServiceFactory(GEODE_CONTEXT).create(username, password);
    }

    public static ClusterManagementService getService(String host, int port) {
        return ClusterManagementServiceProvider.getServiceFactory(JAVA_CLIENT_CONTEXT).create(host, port, null, null, null, null);
    }

    public static ClusterManagementService getService(String host, int port, SSLContext sslContext, HostnameVerifier hostnameVerifier, String username, String password) {
        return ClusterManagementServiceProvider.getServiceFactory(JAVA_CLIENT_CONTEXT).create(host, port, sslContext, hostnameVerifier, username, password);
    }

    public static ClusterManagementService getService(ClientHttpRequestFactory requestFactory) {
        return ClusterManagementServiceProvider.getServiceFactory(JAVA_CLIENT_CONTEXT).create(requestFactory);
    }

    private static synchronized ClusterManagementServiceFactory getServiceFactory(String context) {
        ClusterManagementServiceFactory factory;
        if (serviceFactories == null) {
            ClusterManagementServiceProvider.loadClusterManagementServiceFactories();
        }
        if ((factory = serviceFactories.get(context)) == null) {
            throw new IllegalArgumentException("Did not find provider for context: " + context);
        }
        return factory;
    }

    private static void loadClusterManagementServiceFactories() {
        serviceFactories = new HashMap<String, ClusterManagementServiceFactory>();
        for (ClusterManagementServiceFactory factory : ServiceLoader.load(ClusterManagementServiceFactory.class)) {
            serviceFactories.put(factory.getContext(), factory);
        }
    }
}

