/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.log4j.internal.impl;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.logging.log4j.internal.impl.DebuggableAppender;
import org.apache.geode.logging.log4j.internal.impl.PausableAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.NullOutputStream;

@Plugin(name="GeodeConsole", category="Core", elementType="appender", printObject=true)
public class GeodeConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager>
implements PausableAppender,
DebuggableAppender {
    public static final String PLUGIN_NAME = "GeodeConsole";
    private static final boolean START_PAUSED_BY_DEFAULT = false;
    @Immutable
    private static final ConsoleAppender.Target DEFAULT_TARGET = ConsoleAppender.Target.SYSTEM_OUT;
    @MakeNotStatic
    private static final AtomicInteger COUNT = new AtomicInteger();
    @Immutable
    private static final GeodeConsoleManagerFactory MANAGER_FACTORY = new GeodeConsoleManagerFactory();
    private final ConsoleAppender delegate;
    private final boolean debug;
    private final List<LogEvent> events;
    private volatile boolean paused;

    protected GeodeConsoleAppender(String name, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager manager, ConsoleAppender delegate) {
        this(name, layout, filter, manager, true, false, false, delegate);
    }

    protected GeodeConsoleAppender(String name, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions, boolean startPaused, boolean debug, ConsoleAppender delegate) {
        super(name, layout, filter, ignoreExceptions, true, manager);
        this.delegate = delegate;
        this.debug = debug;
        this.events = debug ? Collections.synchronizedList(new ArrayList()) : Collections.emptyList();
        this.paused = startPaused;
    }

    public static GeodeConsoleAppender createDefaultAppenderForLayout(Layout<? extends Serializable> layout) {
        return new GeodeConsoleAppender("GeodeConsole-" + COUNT.incrementAndGet(), layout, null, GeodeConsoleAppender.getDefaultManager(DEFAULT_TARGET, false, false, layout), true, false, false, ConsoleAppender.createDefaultAppenderForLayout(layout));
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public void append(LogEvent event) {
        if (this.isPaused()) {
            return;
        }
        this.delegate.append(event);
        if (this.debug) {
            this.events.add(event);
        }
    }

    public void start() {
        LOGGER.info("Starting {}.", (Object)this);
        this.delegate.start();
        super.start();
    }

    public void stop() {
        LOGGER.info("Stopping {}.", (Object)this);
        this.delegate.stop();
        super.stop();
    }

    @Override
    public void pause() {
        LOGGER.debug("Pausing {}.", (Object)this);
        this.paused = true;
    }

    @Override
    public void resume() {
        LOGGER.debug("Resuming {}.", (Object)this);
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void clearLogEvents() {
        this.events.clear();
    }

    @Override
    public List<LogEvent> getLogEvents() {
        return this.events;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ":" + this.getName() + " {paused=" + this.paused + ", debug=" + this.debug + ", delegate=" + this.delegate + "}";
    }

    @VisibleForTesting
    ConsoleAppender getDelegate() {
        return this.delegate;
    }

    private static OutputStreamManager getDefaultManager(ConsoleAppender.Target target, boolean follow, boolean direct, Layout<? extends Serializable> layout) {
        NullOutputStream os = NullOutputStream.getInstance();
        String managerName = target.name() + '.' + follow + '.' + direct + "-" + COUNT.get();
        return OutputStreamManager.getManager((String)managerName, (Object)new FactoryData((OutputStream)os, managerName, layout), (ManagerFactory)MANAGER_FACTORY);
    }

    private static OutputStreamManager getManager(ConsoleAppender.Target target, boolean follow, boolean direct, Layout<? extends Serializable> layout) {
        NullOutputStream os = NullOutputStream.getInstance();
        String managerName = "null." + target.name() + '.' + follow + '.' + direct;
        return OutputStreamManager.getManager((String)managerName, (Object)new FactoryData((OutputStream)os, managerName, layout), (ManagerFactory)MANAGER_FACTORY);
    }

    static /* synthetic */ ConsoleAppender.Target access$100() {
        return DEFAULT_TARGET;
    }

    private static class GeodeConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private GeodeConsoleManagerFactory() {
        }

        public OutputStreamManager createManager(String name, FactoryData data) {
            return new AccessibleOutputStreamManager(data.os, data.name, data.layout, true);
        }
    }

    private static class AccessibleOutputStreamManager
    extends OutputStreamManager {
        protected AccessibleOutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader) {
            super(os, streamName, layout, writeHeader);
        }

        protected AccessibleOutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader, int bufferSize) {
            super(os, streamName, layout, writeHeader, bufferSize);
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String name;
        private final Layout<? extends Serializable> layout;

        public FactoryData(OutputStream os, String type, Layout<? extends Serializable> layout) {
            this.os = os;
            this.name = type;
            this.layout = layout;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<GeodeConsoleAppender> {
        @PluginBuilderAttribute
        @Required
        private ConsoleAppender.Target target = GeodeConsoleAppender.access$100();
        @PluginBuilderAttribute
        private boolean follow;
        @PluginBuilderAttribute
        private boolean direct;
        @PluginBuilderAttribute
        private boolean startPaused = false;
        @PluginBuilderAttribute
        private boolean debug;

        public B setTarget(ConsoleAppender.Target aTarget) {
            this.target = aTarget;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFollow(boolean shouldFollow) {
            this.follow = shouldFollow;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setDirect(boolean shouldDirect) {
            this.direct = shouldDirect;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setStartPaused(boolean shouldStartPaused) {
            this.startPaused = shouldStartPaused;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isStartPaused() {
            return this.debug;
        }

        public B setDebug(boolean shouldDebug) {
            this.debug = shouldDebug;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isDebug() {
            return this.debug;
        }

        public GeodeConsoleAppender build() {
            ConsoleAppender.Builder delegate = new ConsoleAppender.Builder();
            delegate.withFilter(this.getFilter());
            delegate.withName(this.getName() + "_DELEGATE");
            delegate.withIgnoreExceptions(this.isIgnoreExceptions());
            delegate.withLayout(this.getLayout());
            delegate.withImmediateFlush(this.isImmediateFlush());
            delegate.withBufferedIo(this.isBufferedIo());
            delegate.withBufferSize(this.getBufferSize());
            delegate.setTarget(this.target);
            delegate.setFollow(this.follow);
            delegate.setDirect(this.direct);
            Layout layout = this.getOrCreateLayout(this.target.getDefaultCharset());
            return new GeodeConsoleAppender(this.getName(), (Layout<? extends Serializable>)layout, this.getFilter(), GeodeConsoleAppender.getManager(this.target, this.follow, this.direct, (Layout<? extends Serializable>)layout), this.isIgnoreExceptions(), this.startPaused, this.debug, delegate.build());
        }
    }
}

