/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.test.junit.runners.SuiteBlockRunner;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class SuiteRunner
extends Suite {
    public SuiteRunner(Class<?> testClass, RunnerBuilder builder) throws InitializationError {
        super(testClass, SuiteRunner.getRunners(testClass));
    }

    private static List<Runner> getRunners(Class<?> testClass) throws InitializationError {
        Suite.SuiteClasses annotation = testClass.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", testClass.getName()));
        }
        Candidate candidate = testClass.getAnnotation(Candidate.class);
        Class<?> candidateClass = null;
        if (candidate != null) {
            candidateClass = candidate.value();
        }
        Class[] childClasses = annotation.value();
        ArrayList<Runner> runners = new ArrayList<Runner>();
        for (Class childClass : childClasses) {
            runners.add((Runner)new SuiteBlockRunner(testClass, childClass));
            if (candidateClass == null) continue;
            runners.add((Runner)new SuiteBlockRunner(testClass, candidateClass));
        }
        return runners;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface Candidate {
        public Class<?> value();
    }
}

