/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules.gfsh;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geode.test.junit.rules.gfsh.GfshExecution;
import org.apache.geode.test.junit.rules.gfsh.GfshRule;
import org.assertj.core.api.Assertions;

public class GfshScript {
    private final String[] commands;
    private String name;
    private TimeUnit timeoutTimeUnit = TimeUnit.MINUTES;
    private int timeout = 1;
    private boolean awaitQuietly = false;
    private int expectedExitValue = 0;
    private List<String> extendedClasspath = new ArrayList<String>();

    public GfshScript(String ... commands) {
        this.commands = commands;
        this.name = this.defaultName(commands);
    }

    public static GfshScript of(String ... commands) {
        return new GfshScript(commands);
    }

    public GfshScript withName(String name) {
        this.name = name;
        return this;
    }

    public GfshScript expectExitCode(int expectedExitCode) {
        this.expectedExitValue = expectedExitCode;
        return this;
    }

    public GfshScript expectFailure() {
        return this.expectExitCode(1);
    }

    public GfshScript awaitAtMost(int timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeoutTimeUnit = timeUnit;
        return this;
    }

    public List<String> getExtendedClasspath() {
        return this.extendedClasspath;
    }

    public GfshScript addToClasspath(String classpath) {
        this.extendedClasspath.add(classpath);
        return this;
    }

    public GfshScript awaitQuietlyAtMost(int timeout, TimeUnit timeUnit) {
        this.awaitQuietly = true;
        return this.awaitAtMost(timeout, timeUnit);
    }

    public GfshScript awaitQuietly() {
        this.awaitQuietly = true;
        return this;
    }

    public GfshExecution execute(GfshRule gfshRule) {
        return gfshRule.execute(this);
    }

    protected void awaitIfNecessary(Process process) {
        if (this.shouldAwaitQuietly()) {
            this.awaitQuietly(process);
        } else if (this.shouldAwaitLoudly()) {
            this.awaitLoudly(process);
        }
        Assertions.assertThat((int)process.exitValue()).isEqualTo(this.expectedExitValue);
    }

    private void awaitQuietly(Process process) {
        try {
            process.waitFor(this.timeout, this.timeoutTimeUnit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void awaitLoudly(Process process) {
        boolean exited;
        try {
            exited = process.waitFor(this.timeout, this.timeoutTimeUnit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertThat((boolean)exited).isTrue();
    }

    private boolean shouldAwait() {
        return this.timeoutTimeUnit != null;
    }

    private boolean shouldAwaitQuietly() {
        return this.shouldAwait() && this.awaitQuietly;
    }

    private boolean shouldAwaitLoudly() {
        return this.shouldAwait() && !this.awaitQuietly;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public String getName() {
        return this.name;
    }

    private String defaultName(String ... commands) {
        try {
            return commands[0].substring(0, commands[0].indexOf("-")).trim();
        }
        catch (Exception handled) {
            return commands[0];
        }
    }
}

