/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.concurrent;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class FileBasedCountDownLatch
implements Serializable {
    private final File lockFile = File.createTempFile("CountDownLatchLock", ".txt");
    private final File dataFile = File.createTempFile("CountDownLatchData", ".txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedCountDownLatch(int count) throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.lockFile);){
            FileLock lock = out.getChannel().lock();
            try {
                FileUtils.writeStringToFile((File)this.dataFile, (String)String.valueOf(count), (Charset)Charsets.UTF_8);
            }
            finally {
                lock.release();
            }
        }
        this.lockFile.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countDown() throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.lockFile);){
            FileLock lock = out.getChannel().lock();
            try {
                String fileContents = FileUtils.readFileToString((File)this.dataFile, (Charset)Charsets.UTF_8);
                int currentValue = Integer.valueOf(fileContents);
                int newValue = currentValue - 1;
                FileUtils.writeStringToFile((File)this.dataFile, (String)String.valueOf(newValue), (Charset)Charsets.UTF_8);
            }
            finally {
                lock.release();
            }
        }
    }

    public void await() throws IOException {
        Awaitility.await().atMost(10L, TimeUnit.MINUTES).until(this::currentValue, Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int currentValue() throws IOException {
        Throwable throwable = null;
        try (FileOutputStream out = new FileOutputStream(this.lockFile);){
            int n;
            FileLock lock = out.getChannel().lock();
            try {
                String fileContents = FileUtils.readFileToString((File)this.dataFile, (Charset)Charsets.UTF_8);
                n = Integer.valueOf(fileContents);
            }
            catch (Throwable throwable2) {
                try {
                    lock.release();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            lock.release();
            return n;
        }
    }
}

