/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.benchmark.jmh.profilers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.benchmark.jmh.profilers.ObjectSizeAgent;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;

public class ObjectSizeProfiler
implements InternalProfiler {
    private static final HashMap<String, Object> objects = new HashMap();
    private static boolean enabled = false;

    public static void objectSize(String name, Object object) {
        if (!enabled) {
            return;
        }
        objects.put(name, object);
    }

    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        enabled = true;
    }

    public Collection<? extends Result<?>> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        ArrayList results = new ArrayList();
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            result.addResult((Result)new ScalarResult("objectSize." + entry.getKey(), (double)ObjectSizeAgent.sizeOfDeep(entry.getValue()), "bytes", AggregationPolicy.AVG));
        }
        return results;
    }

    public String getDescription() {
        return "Adds size of objects after iteration.";
    }
}

