/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.test.dunit.Blackboard;
import org.apache.geode.test.dunit.DUnitBlackboard;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.InternalBlackboard;
import org.apache.geode.test.dunit.internal.InternalBlackboardImpl;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;

public class DistributedBlackboard
extends AbstractDistributedRule
implements Blackboard {
    private static final AtomicReference<DUnitBlackboard> BLACKBOARD = new AtomicReference();
    private static final AtomicReference<InternalBlackboard> INTERNAL = new AtomicReference();
    private final Map<Integer, Map<String, Boolean>> keepGates = new ConcurrentHashMap<Integer, Map<String, Boolean>>();
    private final Map<Integer, Map<String, Serializable>> keepMailboxes = new ConcurrentHashMap<Integer, Map<String, Serializable>>();

    @Override
    protected void before() {
        this.invoker().invokeInEveryVMAndController(this::invokeBefore);
    }

    @Override
    protected void after() throws Throwable {
        this.invoker().invokeInEveryVMAndController(this::invokeAfter);
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(this::invokeBefore);
    }

    @Override
    protected void beforeBounceVM(VM vm) {
        this.keepGates.put(vm.getId(), (Map)vm.invoke(() -> INTERNAL.get().gates()));
        this.keepMailboxes.put(vm.getId(), (Map)vm.invoke(() -> INTERNAL.get().mailboxes()));
    }

    @Override
    protected void afterBounceVM(VM vm) {
        Map<String, Boolean> keepGatesForVM = this.keepGates.remove(vm.getId());
        Map<String, Serializable> keepMailboxesForVM = this.keepMailboxes.remove(vm.getId());
        vm.invoke(() -> {
            this.invokeBefore();
            INTERNAL.get().putGates(keepGatesForVM);
            INTERNAL.get().putMailboxes(keepMailboxesForVM);
        });
    }

    private void invokeBefore() {
        InternalBlackboard internalBlackboard = InternalBlackboardImpl.getInstance();
        INTERNAL.set(internalBlackboard);
        BLACKBOARD.set(new DUnitBlackboard(internalBlackboard));
    }

    private void invokeAfter() {
        BLACKBOARD.set(null);
        INTERNAL.set(null);
    }

    @Override
    public void initBlackboard() {
        BLACKBOARD.get().initBlackboard();
    }

    @Override
    public void signalGate(String gateName) {
        BLACKBOARD.get().signalGate(gateName);
    }

    @Override
    public void waitForGate(String gateName) throws TimeoutException, InterruptedException {
        BLACKBOARD.get().waitForGate(gateName);
    }

    @Override
    public void waitForGate(String gateName, long timeout, TimeUnit units) throws TimeoutException, InterruptedException {
        BLACKBOARD.get().waitForGate(gateName, timeout, units);
    }

    @Override
    public void clearGate(String gateName) {
        BLACKBOARD.get().clearGate(gateName);
    }

    @Override
    public boolean isGateSignaled(String gateName) {
        return BLACKBOARD.get().isGateSignaled(gateName);
    }

    @Override
    public <T> void setMailbox(String boxName, T value) {
        BLACKBOARD.get().setMailbox(boxName, (Object)value);
    }

    @Override
    public <T> T getMailbox(String boxName) {
        return BLACKBOARD.get().getMailbox(boxName);
    }
}

