/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public class MethodInvokerResult
implements Serializable {
    public static final Serializable EXCEPTION_OCCURRED = new Serializable(){

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public String toString() {
            return "EXCEPTION_OCCURRED";
        }
    };
    private final Object result;
    private final Throwable exception;
    private String stackTrace;

    MethodInvokerResult(Object result) {
        this.result = result;
        this.exception = null;
    }

    MethodInvokerResult(Throwable throwable) {
        this.result = EXCEPTION_OCCURRED;
        this.exception = MethodInvokerResult.checkSerializable(throwable);
        this.stackTrace = MethodInvokerResult.toStackTrace(throwable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResult());
        sb.append(System.lineSeparator());
        if (this.getStackTrace() != null) {
            sb.append(this.getStackTrace());
        }
        return sb.toString();
    }

    public Object getResult() {
        return this.result;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean exceptionOccurred() {
        return EXCEPTION_OCCURRED.equals(this.result);
    }

    private static String toStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    private static Throwable checkSerializable(Throwable throwable) {
        Throwable throwable2;
        ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());
        try {
            oos.writeObject(throwable);
            throwable2 = throwable;
        }
        catch (Throwable throwable3) {
            try {
                try {
                    oos.close();
                }
                catch (Throwable throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                return new IOException(sw.toString());
            }
        }
        oos.close();
        return throwable2;
    }
}

