/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.Serializable;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class GeodeDataCommandsDistributedTestBase {
    private static final String DATA_REGION_NAME = "GeodeDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1 = "GeodeDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2 = "GeodeDataCommandsTestRegion_Vm2";
    private static final String DATA_REGION_NAME_PATH = "/GeodeDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1_PATH = "/GeodeDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2_PATH = "/GeodeDataCommandsTestRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME = "GeodeDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1 = "GeodeDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2 = "GeodeDataCommandsTestParRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME_PATH = "/GeodeDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1_PATH = "/GeodeDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2_PATH = "/GeodeDataCommandsTestParRegion_Vm2";
    private static final String DATA_REGION_NAME_CHILD_1 = "ChildRegionRegion1";
    private static final String DATA_REGION_NAME_CHILD_1_2 = "ChildRegionRegion12";
    private static final String SERIALIZATION_FILTER = "org.apache.geode.management.internal.cli.**";
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();
    protected MemberVM locator;
    protected MemberVM server1;
    protected MemberVM server2;

    public void connectToLocator() throws Exception {
        this.gfsh.connectAndVerify(this.locator, new String[0]);
    }

    private static void setupRegions(String regionName, String parRegionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        Region dataRegion = regionFactory.create(DATA_REGION_NAME);
        dataRegion = regionFactory.createSubregion(dataRegion, DATA_REGION_NAME_CHILD_1);
        regionFactory.createSubregion(dataRegion, DATA_REGION_NAME_CHILD_1_2);
        regionFactory.create(regionName);
        PartitionAttributes partitionAttrs = new PartitionAttributesFactory().setRedundantCopies(2).create();
        RegionFactory partitionRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        partitionRegionFactory.setPartitionAttributes(partitionAttrs);
        partitionRegionFactory.create(DATA_PAR_REGION_NAME);
        partitionRegionFactory.create(parRegionName);
    }

    void setupForGetPutRemoveLocateEntry(String testName) throws Exception {
        Properties props = GeodeDataCommandsDistributedTestBase.locatorProperties();
        props.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        props.setProperty("name", testName + "Manager");
        Properties serverProps = new Properties();
        serverProps.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        this.locator = this.cluster.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(props));
        this.server1 = this.cluster.startServerVM(1, serverProps, this.locator.getPort());
        this.server2 = this.cluster.startServerVM(2, serverProps, this.locator.getPort());
        this.connectToLocator();
        this.server1.invoke(() -> GeodeDataCommandsDistributedTestBase.setupRegions(DATA_REGION_NAME_VM1, DATA_PAR_REGION_NAME_VM1));
        this.server2.invoke(() -> GeodeDataCommandsDistributedTestBase.setupRegions(DATA_REGION_NAME_VM2, DATA_PAR_REGION_NAME_VM2));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_VM1_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_VM2_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_VM1_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_VM2_PATH, 1);
        this.locator.invoke(() -> {
            String[] regions;
            InternalCache cache = ClusterStartupRule.getCache();
            ManagementService service = ManagementService.getManagementService((Cache)cache);
            DistributedRegionMXBean bean = service.getDistributedRegionMXBean(DATA_REGION_NAME_PATH);
            for (String region : regions = new String[]{DATA_REGION_NAME_PATH, DATA_REGION_NAME_VM1_PATH, DATA_REGION_NAME_VM2_PATH, DATA_PAR_REGION_NAME_PATH, DATA_PAR_REGION_NAME_VM1_PATH, DATA_PAR_REGION_NAME_VM2_PATH}) {
                bean = service.getDistributedRegionMXBean(region);
                if (bean.getMemberCount() >= 1) continue;
                Assertions.fail((String)"Even after waiting mbean reports number of member hosting region /GeodeDataCommandsTestRegion_Vm1 is less than one");
            }
        });
    }

    @Test
    public void testPrimitivesWithDataCommands() throws Exception {
        this.setupForGetPutRemoveLocateEntry("testPrimitives");
        Byte byteKey = Byte.parseByte("41");
        Byte byteValue = Byte.parseByte("31");
        Short shortKey = Short.parseShort("123");
        Short shortValue = Short.parseShort("121");
        Integer integerKey = Integer.parseInt("123456");
        Integer integerValue = Integer.parseInt("12345678");
        Float floatKey = Float.valueOf("12432.2325");
        Float floatValue = Float.valueOf("111111.1111");
        Double doubleKey = Double.valueOf("12432.235425");
        Double doubleValue = Double.valueOf("111111.111111");
        this.testGetPutLocateEntryFromShellAndGeode(byteKey, byteValue, Byte.class, true, true);
        this.testGetPutLocateEntryFromShellAndGeode(shortKey, shortValue, Short.class, true, true);
        this.testGetPutLocateEntryFromShellAndGeode(integerKey, integerValue, Integer.class, true, true);
        this.testGetPutLocateEntryFromShellAndGeode(floatKey, floatValue, Float.class, true, true);
        this.testGetPutLocateEntryFromShellAndGeode(doubleKey, doubleValue, Double.class, true, true);
    }

    private void testGetPutLocateEntryFromShellAndGeode(Serializable key, Serializable value, Class<?> klass, boolean addRegionPath, boolean expResult) {
        SerializableRunnableIF putTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            region.clear();
            region.put((Object)key, (Object)value);
        };
        SerializableRunnableIF getTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            Assertions.assertThat((boolean)region.containsKey((Object)key)).isTrue();
            Assertions.assertThat((Object)value).isEqualTo(region.get((Object)key));
        };
        SerializableRunnableIF removeTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            Assertions.assertThat((boolean)region.containsKey((Object)key)).isTrue();
            region.remove((Object)key);
        };
        SerializableRunnableIF clearTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            region.clear();
        };
        String canonicalName = klass.getCanonicalName();
        String getCommand = "get --key=" + String.valueOf(key) + " --key-class=" + canonicalName + " --value-class=" + canonicalName;
        if (addRegionPath) {
            getCommand = getCommand + " --region=/GeodeDataCommandsTestRegion";
        }
        String locateEntryCommand = "locate entry --key=" + String.valueOf(key) + " --key-class=" + canonicalName + " --value-class=" + canonicalName;
        if (addRegionPath) {
            locateEntryCommand = locateEntryCommand + " --region=/GeodeDataCommandsTestRegion";
        }
        String removeCommand = "remove --key=" + String.valueOf(key) + " --key-class=" + canonicalName;
        if (addRegionPath) {
            removeCommand = removeCommand + " --region=/GeodeDataCommandsTestRegion";
        }
        String putCommand = "put --key=" + String.valueOf(key) + " --key-class=" + canonicalName + " --value=" + String.valueOf(value) + " --value-class=" + canonicalName;
        if (addRegionPath) {
            putCommand = putCommand + " --region=/GeodeDataCommandsTestRegion";
        }
        if (expResult) {
            this.gfsh.executeAndAssertThat(putCommand).statusIsSuccess().containsOutput(new String[]{"true"});
            this.server1.invoke(getTask);
            this.server1.invoke(removeTask);
            this.server1.invoke(clearTask);
            this.server1.invoke(putTask);
            this.gfsh.executeAndAssertThat(getCommand).statusIsSuccess().containsOutput(new String[]{"true"});
            this.gfsh.executeAndAssertThat(locateEntryCommand).statusIsSuccess().containsOutput(new String[]{"true"});
            this.server1.invoke(removeTask);
            this.server1.invoke(clearTask);
            this.gfsh.executeAndAssertThat(putCommand).statusIsSuccess().containsOutput(new String[]{"true"});
            this.server1.invoke(getTask);
            this.gfsh.executeAndAssertThat(removeCommand).statusIsSuccess().containsOutput(new String[]{"true"});
            this.gfsh.executeAndAssertThat(getCommand).statusIsSuccess().containsOutput(new String[]{"false"});
            this.gfsh.executeAndAssertThat(locateEntryCommand).statusIsSuccess().containsOutput(new String[]{"false"});
        } else {
            this.gfsh.executeAndAssertThat(putCommand).statusIsSuccess().containsOutput(new String[]{"false"});
            this.server1.invoke(clearTask);
            this.server1.invoke(putTask);
            this.gfsh.executeAndAssertThat(getCommand).statusIsSuccess().containsOutput(new String[]{"false"});
            this.gfsh.executeAndAssertThat(locateEntryCommand).statusIsSuccess().containsOutput(new String[]{"false"});
            this.server1.invoke(removeTask);
            this.server1.invoke(clearTask);
            this.gfsh.executeAndAssertThat(putCommand).statusIsSuccess().containsOutput(new String[]{"false"});
        }
    }

    private static Properties locatorProperties() {
        int jmxPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "fine");
        props.setProperty("jmx-manager-hostname-for-clients", "localhost");
        props.setProperty("jmx-manager-port", "" + jmxPort);
        return props;
    }
}

