/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.CacheUtils;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.data.Portfolio;
import org.apache.geode.cache.query.data.Position;
import org.apache.geode.cache.query.functional.StructSetOrResultsSet;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverAdapter;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class OrderByTestImplementation {
    @Before
    public void setUp() throws Exception {
        CacheUtils.startCache();
    }

    @After
    public void tearDown() throws Exception {
        CacheUtils.closeCache();
    }

    public abstract Region createRegion(String var1, Class var2);

    public abstract Index createIndex(String var1, IndexType var2, String var3, String var4) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException;

    public abstract Index createIndex(String var1, String var2, String var3) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException;

    public abstract boolean assertIndexUsedOnQueryNode();

    @Test
    public void testOrderByWithIndexResultDefaultProjection() throws Exception {
        Query q;
        int i;
        String[] queries = new String[]{"SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID asc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID asc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID asc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc limit 5 ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID asc limit 10", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID desc limit 10"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                SelectResults rcw = (SelectResults)r[i][1];
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                Assert.assertTrue((String)("Result size is " + rcw.size() + " and limit is " + limit), (!limitQuery || rcw.size() <= limit ? 1 : 0) != 0);
                String colType = rcw.getCollectionType().getSimpleClassName();
                if (!colType.equals("Ordered") && !colType.equals("LinkedHashSet")) {
                    Assert.fail((String)("The collection type " + colType + " is not expexted"));
                }
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                Iterator itr = observer.indexesUsed.iterator();
                while (itr.hasNext()) {
                    if (itr.next().toString().equals("IDIndexPf1")) continue;
                    Assert.fail((String)("<IDIndexPf1> was expected but found " + itr.next().toString()));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    @Test
    public void testOrderByWithColumnAlias_Bug52041_1() throws Exception {
        Region region = this.createRegion("portfolio", Portfolio.class);
        for (int i = 1; i < 200; ++i) {
            Portfolio pf = new Portfolio(i);
            pf.shortID = (short)((short)i / 5);
            pf.status = "active";
            region.put((Object)("" + i), (Object)pf);
        }
        String queryStr = "select distinct p.status, p.shortID as short_id  from /portfolio p where p.ID >= 0 order by short_id asc";
        QueryService qs = CacheUtils.getQueryService();
        Query query = qs.newQuery(queryStr);
        SelectResults results = (SelectResults)query.execute();
        Iterator iter = results.asList().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            Struct str = (Struct)iter.next();
            Assert.assertEquals((long)counter, (long)((Short)str.get("short_id")).intValue());
            ++counter;
        }
        Assert.assertEquals((long)39L, (long)(counter - 1));
        CompiledSelect cs = ((DefaultQuery)query).getSimpleSelect();
        List orderbyAtts = cs.getOrderByAttrs();
        Assert.assertEquals((long)((CompiledSortCriterion)orderbyAtts.get(0)).getColumnIndex(), (long)1L);
    }

    @Test
    public void testOrderByWithColumnAlias_Bug52041_2() throws Exception {
        Region region = this.createRegion("portfolio", Portfolio.class);
        for (int i = 0; i < 200; ++i) {
            Portfolio pf = new Portfolio(i);
            pf.shortID = (short)((short)i / 5);
            pf.status = "active";
            region.put((Object)("" + i), (Object)pf);
        }
        String queryStr = "select distinct p.ID as _id, p.shortID as short_id  from /portfolio p where p.ID >= 0 order by short_id asc, p.ID desc";
        QueryService qs = CacheUtils.getQueryService();
        Query query = qs.newQuery(queryStr);
        SelectResults results = (SelectResults)query.execute();
        Iterator iter = results.asList().iterator();
        int counter = 0;
        int k = 0;
        while (iter.hasNext()) {
            k = (counter / 5 + 1) * 5 - 1;
            Struct str = (Struct)iter.next();
            Assert.assertEquals((long)(counter / 5), (long)((Short)str.get("short_id")).intValue());
            Assert.assertEquals((long)(k - counter % 5), (long)((Integer)str.get("_id")).intValue());
            ++counter;
        }
        CompiledSelect cs = ((DefaultQuery)query).getSimpleSelect();
        List orderbyAtts = cs.getOrderByAttrs();
        Assert.assertEquals((long)((CompiledSortCriterion)orderbyAtts.get(0)).getColumnIndex(), (long)1L);
        Assert.assertEquals((long)((CompiledSortCriterion)orderbyAtts.get(1)).getColumnIndex(), (long)0L);
    }

    @Test
    public void testOrderByWithIndexResultWithProjection() throws Exception {
        Query q;
        int i;
        String[] queries = new String[]{"SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 order by ID desc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 order by ID asc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID != 10 order by ID asc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID != 10 order by ID desc ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 order by ID desc limit 5", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 order by ID asc limit 5", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc limit 5 ", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc limit 5", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc limit 5", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc limit 5", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID != 10 order by ID asc limit 10", "SELECT  distinct ID, description, createTime FROM /portfolio1 pf1 where ID != 10 order by ID desc limit 10"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                SelectResults rcw = (SelectResults)r[i][1];
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                Assert.assertTrue((!limitQuery || rcw.size() <= limit ? 1 : 0) != 0);
                String colType = rcw.getCollectionType().getSimpleClassName();
                if (!colType.equals("Ordered") && !colType.equals("LinkedHashSet")) {
                    Assert.fail((String)("The collection type " + colType + " is not expexted"));
                }
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                Iterator itr = observer.indexesUsed.iterator();
                while (itr.hasNext()) {
                    if (itr.next().toString().equals("IDIndexPf1")) continue;
                    Assert.fail((String)("<IDIndexPf1> was expected but found " + itr.next().toString()));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    @Test
    public void testMultiColOrderByWithIndexResultDefaultProjection() throws Exception {
        Query q;
        int i;
        String[] queries = new String[]{"SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID desc, pkid asc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID asc, pkid desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc, pkid asc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc , pkid desc", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc, pkid desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc, pkid asc", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID asc, pkid asc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID desc, pkid desc ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID desc, pkid asc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 order by ID asc, pkid desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc, pkid asc limit 5 ", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc, pkid desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc, pkid asc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc, pkid desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID asc, pkid asc limit 10", "SELECT  distinct * FROM /portfolio1 pf1 where ID != 10 order by ID desc, pkid desc limit 10"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                SelectResults rcw = (SelectResults)r[i][1];
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                Assert.assertTrue((!limitQuery || rcw.size() <= limit ? 1 : 0) != 0);
                Assert.assertEquals((Object)"Ordered", (Object)rcw.getCollectionType().getSimpleClassName());
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                Iterator itr = observer.indexesUsed.iterator();
                while (itr.hasNext()) {
                    if (itr.next().toString().equals("IDIndexPf1")) continue;
                    Assert.fail((String)("<IDIndexPf1> was expected but found " + itr.next().toString()));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    public abstract String[] getQueriesForMultiColOrderByWithIndexResultWithProjection();

    @Test
    public void testMultiColOrderByWithIndexResultWithProjection() throws Exception {
        Query q;
        int i;
        String[] queries = this.getQueriesForMultiColOrderByWithIndexResultWithProjection();
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                SelectResults rcw = (SelectResults)r[i][1];
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                Assert.assertTrue((!limitQuery || rcw.size() <= limit ? 1 : 0) != 0);
                Assert.assertEquals((Object)"Ordered", (Object)rcw.getCollectionType().getSimpleClassName());
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                Iterator itr = observer.indexesUsed.iterator();
                while (itr.hasNext()) {
                    if (itr.next().toString().equals("IDIndexPf1")) continue;
                    Assert.fail((String)("<IDIndexPf1> was expected but found " + itr.next().toString()));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    @Test
    public void testMultiColOrderByWithMultiIndexResultDefaultProjection() throws Exception {
        Query q;
        int i;
        String[] queries = new String[]{"SELECT  distinct * FROM /portfolio1 pf1 where pkid = '12' and ID > 10 order by ID desc, pkid asc ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '1' and ID > 10 order by ID asc, pkid desc ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid = '13'and  ID > 10 and ID < 20 order by ID asc, pkid asc ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid <'9' and ID > 10 and ID < 20 order by ID desc , pkid desc", "SELECT  distinct * FROM /portfolio1 pf1 where pkid = '15' and ID >= 10 and ID <= 20 order by ID desc, pkid desc ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '1' and pkid <='9' and ID >= 10 and ID <= 20 order by ID asc, pkid asc", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID asc, pkid asc ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID desc, pkid desc ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid = '17' and ID > 10 order by ID desc, pkid asc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '17' and ID > 10 order by ID asc, pkid desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where pkid < '7' and ID > 10 and ID < 20 order by ID asc, pkid asc limit 5 ", "SELECT  distinct * FROM /portfolio1 pf1 where pkid = '18' and ID > 10 and ID < 20 order by ID desc, pkid desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '1' and ID >= 10 and ID <= 20 order by ID desc, pkid asc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where pkid != '17' and ID >= 10 and ID <= 20 order by ID asc, pkid desc limit 5", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '0' and ID != 10 order by ID asc, pkid asc limit 10", "SELECT  distinct * FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID desc, pkid desc limit 10"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        this.createIndex("PKIDIndexPf1", IndexType.FUNCTIONAL, "pkid", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                SelectResults rcw = (SelectResults)r[i][1];
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                Assert.assertTrue((!limitQuery || rcw.size() <= limit ? 1 : 0) != 0);
                Assert.assertEquals((Object)"Ordered", (Object)rcw.getCollectionType().getSimpleClassName());
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                for (Object o : observer.indexesUsed) {
                    String indexUsed = o.toString();
                    if (indexUsed.equals("IDIndexPf1")) continue;
                    Assert.fail((String)("<IDIndexPf1> was expected but found " + indexUsed));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    public abstract String[] getQueriesForMultiColOrderByWithMultiIndexResultProjection();

    @Test
    public void testMultiColOrderByWithMultiIndexResultProjection() throws Exception {
        Query q;
        int i;
        String[] queries = this.getQueriesForMultiColOrderByWithMultiIndexResultProjection();
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        this.createIndex("PKIDIndexPf1", IndexType.FUNCTIONAL, "pkid", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                SelectResults rcw = (SelectResults)r[i][1];
                Assert.assertEquals((Object)"Ordered", (Object)rcw.getCollectionType().getSimpleClassName());
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                Assert.assertTrue((!limitQuery || rcw.size() <= limit ? 1 : 0) != 0);
                for (Object o : observer.indexesUsed) {
                    String indexUsed = o.toString();
                    if (indexUsed.equals("IDIndexPf1")) continue;
                    Assert.fail((String)("<IDIndexPf1> was expected but found " + indexUsed));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    public abstract String[] getQueriesForLimitNotAppliedIfOrderByNotUsingIndex();

    @Test
    public void testLimitNotAppliedIfOrderByNotUsingIndex() throws Exception {
        Query q;
        int i;
        String[] queries = this.getQueriesForLimitNotAppliedIfOrderByNotUsingIndex();
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("PKIDIndexPf1", IndexType.FUNCTIONAL, "pkid", "/portfolio1");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                boolean limitQuery;
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                int indexLimit = queries[i].indexOf("limit");
                int limit = -1;
                boolean bl = limitQuery = indexLimit != -1;
                if (limitQuery) {
                    limit = Integer.parseInt(queries[i].substring(indexLimit + 5).trim());
                }
                SelectResults rcw = (SelectResults)r[i][1];
                Assert.assertEquals((Object)"Ordered", (Object)rcw.getCollectionType().getSimpleClassName());
                if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                    Assert.fail((String)"Index is NOT uesd");
                }
                Assert.assertTrue((!limitQuery || !observer.limitAppliedAtIndex ? 1 : 0) != 0);
                for (Object o : observer.indexesUsed) {
                    String indexUsed = o.toString();
                    if (indexUsed.equals("PKIDIndexPf1")) continue;
                    Assert.fail((String)("<PKIDIndexPf1> was expected but found " + indexUsed));
                }
                int indxs = observer.indexesUsed.size();
                System.out.println("**************************************************Indexes Used :::::: " + indxs + " Index Name: " + observer.indexName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
        ssOrrs.compareExternallySortedQueriesWithOrderBy(queries, r);
    }

    protected abstract String[] getQueriesForOrderByWithNullValues();

    @Test
    public void testOrderByWithNullValuesUseIndex() throws Exception {
        String[] queries = new String[]{"SELECT  distinct * FROM /portfolio1 pf1 where ID > 0 order by pkid", "SELECT  distinct * FROM /portfolio1 pf1 where ID > 0 order by pkid asc", "SELECT  distinct * FROM /portfolio1 where ID > 0 order by pkid desc", "SELECT  distinct pkid FROM /portfolio1 pf1 where ID > 0 order by pkid", "SELECT  distinct pkid FROM /portfolio1 pf1 where ID > 0 order by pkid asc", "SELECT  distinct pkid FROM /portfolio1 pf1 where ID > 0 order by pkid desc", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID < 1000 order by pkid", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID > 3 order by pkid", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID < 1000 order by pkid", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID > 0 order by pkid"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        int size = 9;
        int numNullValues = 3;
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (int i = 1; i <= 9; ++i) {
            Portfolio pf = new Portfolio(i);
            if (i <= 3) {
                pf.pkid = null;
                pf.status = "a" + i;
            }
            r1.put((Object)("" + i), (Object)pf);
        }
        this.createIndex("IDIndexPf1", IndexType.FUNCTIONAL, "ID", "/portfolio1");
        this.createIndex("PKIDIndexPf1", IndexType.FUNCTIONAL, "pkid", "/portfolio1");
        Query q = null;
        SelectResults results = null;
        List list = null;
        String str = "";
        try {
            String pkid;
            Struct vals;
            int id;
            Struct strct;
            String pkid2;
            Portfolio p;
            int i;
            QueryObserverImpl observer = new QueryObserverImpl();
            QueryObserverHolder.setInstance((QueryObserver)observer);
            str = queries[0];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                Assert.fail((String)"Index is NOT uesd");
            }
            r[0][0] = results;
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                p = (Portfolio)list.get(i - 1);
                if (i <= 3) {
                    Assert.assertNull((String)("Expected null value for pkid, p: " + String.valueOf(p)), (Object)p.pkid);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)p.pkid);
                if (p.pkid.equals("" + i)) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[1];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                p = (Portfolio)list.get(i - 1);
                if (i <= 3) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)p.pkid);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)p.pkid);
                if (p.pkid.equals("" + i)) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[2];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                p = (Portfolio)list.get(i - 1);
                if (i > 6) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)p.pkid);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)p.pkid);
                if (p.pkid.equals("" + (9 - (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[3];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                pkid2 = (String)list.get(i - 1);
                if (i == 1) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid2);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid2);
                if (pkid2.equals("" + (3 + (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            observer = new QueryObserverImpl();
            QueryObserverHolder.setInstance((QueryObserver)observer);
            str = queries[4];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            if (this.assertIndexUsedOnQueryNode() && !observer.isIndexesUsed) {
                Assert.fail((String)"Index is NOT uesd");
            }
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                pkid2 = (String)list.get(i - 1);
                if (i == 1) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid2);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid2);
                if (pkid2.equals("" + (3 + (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[5];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                pkid2 = (String)list.get(i - 1);
                if (i == list.size()) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid2);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid2);
                if (pkid2.equals("" + (9 - (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[6];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                strct = (Struct)list.get(i - 1);
                id = (Integer)strct.getFieldValues()[0];
                if (i <= 3) {
                    if (id == 1 || id == 2 || id == 3) continue;
                    Assert.fail((String)(" Value of ID is not as expected " + id));
                    continue;
                }
                if (id == i) continue;
                Assert.fail((String)(" Value of ID is not as expected " + id));
            }
            str = queries[7];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                strct = (Struct)list.get(i - 1);
                id = (Integer)strct.getFieldValues()[0];
                if (id == 3 + i) continue;
                Assert.fail((String)(" Value of ID is not as expected, " + id));
            }
            str = queries[8];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                vals = (Struct)list.get(i - 1);
                id = (Integer)vals.get("ID");
                pkid = (String)vals.get("pkid");
                if (i <= 3) {
                    if (id != 1 && id != 2 && id != 3) {
                        Assert.fail((String)(" Value of ID is not as expected " + id));
                    }
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid);
                    continue;
                }
                if (id != i) {
                    Assert.fail((String)(" Value of ID is not as expected " + id));
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid);
                if (pkid.equals("" + i)) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[9];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                vals = (Struct)list.get(i - 1);
                id = (Integer)vals.get("ID");
                pkid = (String)vals.get("pkid");
                if (i <= 3) {
                    Assert.assertNull((String)("Expected null value for pkid, " + pkid), (Object)pkid);
                    if (id == 1 || id == 2 || id == 3) continue;
                    Assert.fail((String)(" Value of ID is not as expected " + id));
                    continue;
                }
                if (!pkid.equals("" + i)) {
                    Assert.fail((String)(" Value of pkid is not as expected, " + pkid));
                }
                if (id == i) continue;
                Assert.fail((String)(" Value of ID is not as expected, " + id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)q.getQueryString());
        }
    }

    @Test
    public void testOrderByForUndefined() throws Exception {
        int i;
        String[] queries = new String[]{"SELECT DISTINCT position1.secId FROM /test ORDER BY position1.secId", "SELECT DISTINCT position1.secId FROM /test ORDER BY position1.secId desc", "SELECT DISTINCT position1.secId FROM /test where ID > 0  ORDER BY position1.secId", "SELECT DISTINCT position1.secId FROM /test where ID > 0  ORDER BY position1.secId desc", "SELECT DISTINCT position1.secId, ID FROM /test ORDER BY position1.secId, ID", "SELECT DISTINCT position1.secId, ID FROM /test ORDER BY position1.secId desc, ID"};
        Region r1 = this.createRegion("test", Portfolio.class);
        for (int i2 = 0; i2 < 10; ++i2) {
            Portfolio pf = new Portfolio(i2);
            if (i2 % 2 == 0) {
                pf.position1 = null;
            }
            r1.put((Object)("" + i2), (Object)pf);
        }
        QueryService qs = CacheUtils.getQueryService();
        SelectResults[][] sr = new SelectResults[queries.length][2];
        Object[] srArr = null;
        for (i = 0; i < queries.length; ++i) {
            try {
                sr[i][0] = (SelectResults)qs.newQuery(queries[i]).execute();
                srArr = sr[i][0].toArray();
                if (i == 0) {
                    Assert.assertEquals((String)("First result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[0]);
                    continue;
                }
                if (i == 1) {
                    Assert.assertEquals((String)("Last result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[srArr.length - 1]);
                    continue;
                }
                if (i == 2) {
                    Assert.assertEquals((String)("First result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[0]);
                    continue;
                }
                if (i == 3) {
                    Assert.assertEquals((String)("Last result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[srArr.length - 1]);
                    continue;
                }
                if (i == 4) {
                    for (int j = 0; j < srArr.length / 2; ++j) {
                        Assert.assertEquals((String)("Undefined should  have been returned for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)((Struct)srArr[j]).getFieldValues()[0]);
                    }
                    continue;
                }
                if (i != 5) continue;
                for (int j = srArr.length - 1; j > srArr.length / 2; --j) {
                    Assert.assertEquals((String)("Undefined should  have been returned for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)((Struct)srArr[j]).getFieldValues()[0]);
                }
                continue;
            }
            catch (Exception e) {
                Assert.fail((String)("Query execution failed for: " + queries[i] + " : " + String.valueOf(e)));
            }
        }
        this.createIndex("secIndex", "position1.secId", r1.getFullPath());
        this.createIndex("IDIndex", "ID", r1.getFullPath());
        for (i = 0; i < queries.length; ++i) {
            try {
                sr[i][1] = (SelectResults)qs.newQuery(queries[i]).execute();
                srArr = sr[i][1].toArray();
                if (i == 0) {
                    Assert.assertEquals((String)("First result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[0]);
                    continue;
                }
                if (i == 1) {
                    Assert.assertEquals((String)("Last result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[srArr.length - 1]);
                    continue;
                }
                if (i == 2) {
                    Assert.assertEquals((String)("First result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[0]);
                    continue;
                }
                if (i == 3) {
                    Assert.assertEquals((String)("Last result should be undefined for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)srArr[srArr.length - 1]);
                    continue;
                }
                if (i == 4) {
                    for (int j = 0; j < srArr.length / 2; ++j) {
                        Assert.assertEquals((String)("Undefined should  have been returned for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)((Struct)srArr[j]).getFieldValues()[0]);
                    }
                    continue;
                }
                if (i != 5) continue;
                for (int j = srArr.length - 1; j > srArr.length / 2; --j) {
                    Assert.assertEquals((String)("Undefined should  have been returned for query " + queries[i]), (Object)QueryService.UNDEFINED, (Object)((Struct)srArr[j]).getFieldValues()[0]);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Query execution failed for: " + queries[i] + " : " + String.valueOf(e)));
            }
        }
        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
    }

    class QueryObserverImpl
    extends QueryObserverAdapter {
        boolean isIndexesUsed = false;
        ArrayList indexesUsed = new ArrayList();
        String indexName;
        boolean limitAppliedAtIndex = false;

        QueryObserverImpl() {
        }

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexName = index.getName();
            this.indexesUsed.add(index.getName());
        }

        public void afterIndexLookup(Collection results) {
            if (results != null) {
                this.isIndexesUsed = true;
            }
        }

        public void limitAppliedAtIndexLevel(Index index, int limit, Collection indexResult) {
            this.limitAppliedAtIndex = true;
        }
    }
}

