/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.dunit;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqStatusListener;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.assertj.core.api.Assertions;

public class CqQueryTestListener
implements CqStatusListener {
    protected final LogWriter logger;
    protected volatile int eventCreateCount = 0;
    protected volatile int eventUpdateCount = 0;
    protected volatile int eventDeleteCount = 0;
    protected volatile int eventInvalidateCount = 0;
    protected volatile int eventErrorCount = 0;
    protected volatile int totalEventCount = 0;
    protected volatile int eventQueryInsertCount = 0;
    protected volatile int eventQueryUpdateCount = 0;
    protected volatile int eventQueryDeleteCount = 0;
    protected volatile int eventQueryInvalidateCount = 0;
    protected volatile int cqsConnectedCount = 0;
    protected volatile int cqsDisconnectedCount = 0;
    protected volatile boolean eventClose = false;
    protected volatile boolean eventRegionClear = false;
    protected volatile boolean eventRegionInvalidate = false;
    public final Set destroys = ConcurrentHashMap.newKeySet();
    public final Set creates = ConcurrentHashMap.newKeySet();
    public final Set invalidates = ConcurrentHashMap.newKeySet();
    public final Set updates = ConcurrentHashMap.newKeySet();
    public final Set errors = ConcurrentHashMap.newKeySet();
    private static final String WAIT_PROPERTY = "CqQueryTestListener.maxWaitTime";
    private static final int WAIT_DEFAULT = 20000;
    public static final long MAX_TIME = Integer.getInteger("CqQueryTestListener.maxWaitTime", 20000).intValue();
    public String cqName;
    public String userName;
    public static boolean usedForUnitTests = true;
    public ConcurrentLinkedQueue events = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue cqEvents = new ConcurrentLinkedQueue();

    public CqQueryTestListener(LogWriter logger) {
        this.logger = logger;
    }

    public void onEvent(CqEvent cqEvent) {
        ++this.totalEventCount;
        Operation baseOperation = cqEvent.getBaseOperation();
        Operation queryOperation = cqEvent.getQueryOperation();
        Object key = cqEvent.getKey();
        if (key != null) {
            this.events.add(key);
            this.cqEvents.add(cqEvent);
        }
        if (baseOperation.isUpdate()) {
            ++this.eventUpdateCount;
            this.updates.add(key);
        } else if (baseOperation.isCreate()) {
            ++this.eventCreateCount;
            this.creates.add(key);
        } else if (baseOperation.isDestroy()) {
            ++this.eventDeleteCount;
            this.destroys.add(key);
        } else if (baseOperation.isInvalidate()) {
            ++this.eventDeleteCount;
            this.invalidates.add(key);
        }
        if (queryOperation.isUpdate()) {
            ++this.eventQueryUpdateCount;
        } else if (queryOperation.isCreate()) {
            ++this.eventQueryInsertCount;
        } else if (queryOperation.isDestroy()) {
            ++this.eventQueryDeleteCount;
        } else if (queryOperation.isInvalidate()) {
            ++this.eventQueryInvalidateCount;
        } else if (queryOperation.isClear()) {
            this.eventRegionClear = true;
        } else if (queryOperation.isRegionInvalidate()) {
            this.eventRegionInvalidate = true;
        }
    }

    public void onError(CqEvent cqEvent) {
        ++this.eventErrorCount;
        this.errors.add(cqEvent.getThrowable().getMessage());
    }

    public void onCqDisconnected() {
        ++this.cqsDisconnectedCount;
    }

    public void onCqConnected() {
        ++this.cqsConnectedCount;
    }

    public int getErrorEventCount() {
        return this.eventErrorCount;
    }

    public int getTotalEventCount() {
        return this.totalEventCount;
    }

    public int getCreateEventCount() {
        return this.eventCreateCount;
    }

    public int getUpdateEventCount() {
        return this.eventUpdateCount;
    }

    public int getDeleteEventCount() {
        return this.eventDeleteCount;
    }

    public int getInvalidateEventCount() {
        return this.eventInvalidateCount;
    }

    public int getQueryInsertEventCount() {
        return this.eventQueryInsertCount;
    }

    public int getQueryUpdateEventCount() {
        return this.eventQueryUpdateCount;
    }

    public int getQueryDeleteEventCount() {
        return this.eventQueryDeleteCount;
    }

    public int getQueryInvalidateEventCount() {
        return this.eventQueryInvalidateCount;
    }

    public Object[] getEvents() {
        return this.cqEvents.toArray();
    }

    public void close() {
        this.eventClose = true;
    }

    public void printInfo(boolean printKeys) {
        this.logger.info("####" + this.cqName + ":  Events Total :" + this.getTotalEventCount() + " Events Created :" + this.eventCreateCount + " Events Updated :" + this.eventUpdateCount + " Events Deleted :" + this.eventDeleteCount + " Events Invalidated :" + this.eventInvalidateCount + " Query Inserts :" + this.eventQueryInsertCount + " Query Updates :" + this.eventQueryUpdateCount + " Query Deletes :" + this.eventQueryDeleteCount + " Query Invalidates :" + this.eventQueryInvalidateCount + " Total Events :" + this.totalEventCount);
        if (printKeys) {
            this.logger.info("Number of Insert for key : " + this.creates.size() + " and updates : " + this.updates.size() + " and number of destroys : " + this.destroys.size() + " and number of invalidates : " + this.invalidates.size());
            this.logger.info("Keys in created sets : " + String.valueOf(this.creates));
            this.logger.info("Key in updates sets : " + String.valueOf(this.updates));
            this.logger.info("Key in destorys sets : " + String.valueOf(this.destroys));
            this.logger.info("Key in invalidates sets : " + String.valueOf(this.invalidates));
        }
    }

    public void waitForCreated(Object key) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((Collection)this.creates).contains(new Object[]{key}));
    }

    public void waitForTotalEvents(int total) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((int)this.totalEventCount).isEqualTo(total));
    }

    public void waitForDestroyed(Object key) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((Collection)this.destroys).contains(new Object[]{key}));
    }

    public void waitForInvalidated(Object key) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((Collection)this.invalidates).contains(new Object[]{key}));
    }

    public void waitForUpdated(Object key) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((Collection)this.updates).contains(new Object[]{key}));
    }

    public void waitForClose() {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((boolean)this.eventClose).isTrue());
    }

    public void waitForRegionClear() {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((boolean)this.eventRegionClear).isTrue());
    }

    public void waitForRegionInvalidate() {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((boolean)this.eventRegionInvalidate).isTrue());
    }

    public void waitForError(String expectedMessage) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((Collection)this.errors).contains(new Object[]{expectedMessage}));
    }

    public void waitForCqsDisconnectedEvents(int total) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((int)this.cqsDisconnectedCount).isEqualTo(total));
    }

    public void waitForCqsConnectedEvents(int total) {
        GeodeAwaitility.await().untilAsserted(() -> Assertions.assertThat((int)this.cqsConnectedCount).isEqualTo(total));
    }

    public void waitForEvents(int creates, int updates, int deletes, int queryInserts, int queryUpdates, int queryDeletes, int totalEvents) {
        try {
            GeodeAwaitility.await().until(() -> !(creates > 0 && creates != this.getCreateEventCount() || updates > 0 && updates != this.getUpdateEventCount() || deletes > 0 && deletes != this.getDeleteEventCount() || queryInserts > 0 && queryInserts != this.getQueryInsertEventCount() || queryUpdates > 0 && queryUpdates != this.getQueryUpdateEventCount() || queryDeletes > 0 && queryDeletes != this.getQueryDeleteEventCount() || totalEvents > 0 && totalEvents != this.getTotalEventCount()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getEventHistory() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
        this.eventClose = false;
    }
}

