/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.BounceResult;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.internal.MasterRemote;
import org.apache.geode.test.dunit.internal.ProcessManager;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;

public class Master
extends UnicastRemoteObject
implements MasterRemote {
    private static final long serialVersionUID = 1178600200232603119L;
    private final Registry registry;
    private final ProcessManager processManager;

    public Master(Registry registry, ProcessManager processManager) throws RemoteException {
        this.processManager = processManager;
        this.registry = registry;
    }

    @Override
    public int getLocatorPort() throws RemoteException {
        return DUnitLauncher.locatorPort;
    }

    @Override
    public synchronized void signalVMReady() {
        this.processManager.signalVMReady();
    }

    @Override
    public void ping() {
    }

    @Override
    public BounceResult bounce(int pid) {
        return this.bounce("000", pid, false);
    }

    @Override
    public BounceResult bounce(String version, int pid, boolean force) {
        this.processManager.bounce(version, pid, force);
        try {
            if (!this.processManager.waitForVMs(120000L)) {
                throw new RuntimeException("VMs did not start up within 120 seconds");
            }
            RemoteDUnitVMIF remote = (RemoteDUnitVMIF)this.registry.lookup(VM.getVMName("000", pid));
            return new BounceResult(pid, remote);
        }
        catch (NotBoundException | RemoteException e) {
            throw new RuntimeException("could not lookup name", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed waiting for VM", e);
        }
    }
}

