/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.PrintWriter;
import org.apache.geode.GemFireException;
import org.apache.geode.test.dunit.VM;

public class RMIException
extends GemFireException {
    private Throwable cause;
    private String methodName;
    private String className;
    private String exceptionClassName;
    private String stackTrace;
    private VM vm;

    public RMIException(VM vm, String className, String methodName, Throwable cause) {
        super("While invoking " + className + "." + methodName + " in " + vm, cause);
        this.cause = cause;
        this.className = className;
        this.methodName = methodName;
        this.vm = vm;
    }

    public RMIException(VM vm, String className, String methodName, Throwable cause, String stackTrace) {
        super("While invoking " + className + "." + methodName + " in " + vm, (Throwable)new HokeyException(cause, stackTrace));
        this.vm = vm;
        this.cause = cause;
        this.className = className;
        this.methodName = methodName;
        this.stackTrace = stackTrace;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public VM getVM() {
        return this.vm;
    }

    private static class HokeyException
    extends Throwable {
        private String stackTrace;
        private String toString;

        HokeyException(Throwable cause, String stackTrace) {
            this.toString = cause.toString();
            this.stackTrace = stackTrace;
        }

        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print(this.stackTrace);
            pw.flush();
        }

        @Override
        public String toString() {
            return this.toString;
        }
    }
}

